/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.Application;
import software.amazon.awssdk.services.appstream.model.ApplicationsCopier;
import software.amazon.awssdk.services.appstream.model.DynamicAppProvidersEnabled;
import software.amazon.awssdk.services.appstream.model.ImagePermissions;
import software.amazon.awssdk.services.appstream.model.ImageSharedWithOthers;
import software.amazon.awssdk.services.appstream.model.ImageState;
import software.amazon.awssdk.services.appstream.model.ImageStateChangeReason;
import software.amazon.awssdk.services.appstream.model.LatestAppstreamAgentVersion;
import software.amazon.awssdk.services.appstream.model.PlatformType;
import software.amazon.awssdk.services.appstream.model.ResourceError;
import software.amazon.awssdk.services.appstream.model.ResourceErrorsCopier;
import software.amazon.awssdk.services.appstream.model.StringListCopier;
import software.amazon.awssdk.services.appstream.model.VisibilityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Image
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Image> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Image.getter(Image::name)).setter(Image.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Image.getter(Image::arn)).setter(Image.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> BASE_IMAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseImageArn").getter(Image.getter(Image::baseImageArn)).setter(Image.setter(Builder::baseImageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseImageArn").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(Image.getter(Image::displayName)).setter(Image.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Image.getter(Image::stateAsString)).setter(Image.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(Image.getter(Image::visibilityAsString)).setter(Image.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<Boolean> IMAGE_BUILDER_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ImageBuilderSupported").getter(Image.getter(Image::imageBuilderSupported)).setter(Image.setter(Builder::imageBuilderSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageBuilderSupported").build()}).build();
    private static final SdkField<String> IMAGE_BUILDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageBuilderName").getter(Image.getter(Image::imageBuilderName)).setter(Image.setter(Builder::imageBuilderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageBuilderName").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Platform").getter(Image.getter(Image::platformAsString)).setter(Image.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Image.getter(Image::description)).setter(Image.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ImageStateChangeReason> STATE_CHANGE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StateChangeReason").getter(Image.getter(Image::stateChangeReason)).setter(Image.setter(Builder::stateChangeReason)).constructor(ImageStateChangeReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateChangeReason").build()}).build();
    private static final SdkField<List<Application>> APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Applications").getter(Image.getter(Image::applications)).setter(Image.setter(Builder::applications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Applications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Application::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(Image.getter(Image::createdTime)).setter(Image.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> PUBLIC_BASE_IMAGE_RELEASED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PublicBaseImageReleasedDate").getter(Image.getter(Image::publicBaseImageReleasedDate)).setter(Image.setter(Builder::publicBaseImageReleasedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicBaseImageReleasedDate").build()}).build();
    private static final SdkField<String> APPSTREAM_AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppstreamAgentVersion").getter(Image.getter(Image::appstreamAgentVersion)).setter(Image.setter(Builder::appstreamAgentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppstreamAgentVersion").build()}).build();
    private static final SdkField<ImagePermissions> IMAGE_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImagePermissions").getter(Image.getter(Image::imagePermissions)).setter(Image.setter(Builder::imagePermissions)).constructor(ImagePermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImagePermissions").build()}).build();
    private static final SdkField<List<ResourceError>> IMAGE_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImageErrors").getter(Image.getter(Image::imageErrors)).setter(Image.setter(Builder::imageErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LATEST_APPSTREAM_AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestAppstreamAgentVersion").getter(Image.getter(Image::latestAppstreamAgentVersionAsString)).setter(Image.setter(Builder::latestAppstreamAgentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestAppstreamAgentVersion").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_INSTANCE_FAMILIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedInstanceFamilies").getter(Image.getter(Image::supportedInstanceFamilies)).setter(Image.setter(Builder::supportedInstanceFamilies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedInstanceFamilies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DYNAMIC_APP_PROVIDERS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DynamicAppProvidersEnabled").getter(Image.getter(Image::dynamicAppProvidersEnabledAsString)).setter(Image.setter(Builder::dynamicAppProvidersEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicAppProvidersEnabled").build()}).build();
    private static final SdkField<String> IMAGE_SHARED_WITH_OTHERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageSharedWithOthers").getter(Image.getter(Image::imageSharedWithOthersAsString)).setter(Image.setter(Builder::imageSharedWithOthers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageSharedWithOthers").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, BASE_IMAGE_ARN_FIELD, DISPLAY_NAME_FIELD, STATE_FIELD, VISIBILITY_FIELD, IMAGE_BUILDER_SUPPORTED_FIELD, IMAGE_BUILDER_NAME_FIELD, PLATFORM_FIELD, DESCRIPTION_FIELD, STATE_CHANGE_REASON_FIELD, APPLICATIONS_FIELD, CREATED_TIME_FIELD, PUBLIC_BASE_IMAGE_RELEASED_DATE_FIELD, APPSTREAM_AGENT_VERSION_FIELD, IMAGE_PERMISSIONS_FIELD, IMAGE_ERRORS_FIELD, LATEST_APPSTREAM_AGENT_VERSION_FIELD, SUPPORTED_INSTANCE_FAMILIES_FIELD, DYNAMIC_APP_PROVIDERS_ENABLED_FIELD, IMAGE_SHARED_WITH_OTHERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Image.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String baseImageArn;
    private final String displayName;
    private final String state;
    private final String visibility;
    private final Boolean imageBuilderSupported;
    private final String imageBuilderName;
    private final String platform;
    private final String description;
    private final ImageStateChangeReason stateChangeReason;
    private final List<Application> applications;
    private final Instant createdTime;
    private final Instant publicBaseImageReleasedDate;
    private final String appstreamAgentVersion;
    private final ImagePermissions imagePermissions;
    private final List<ResourceError> imageErrors;
    private final String latestAppstreamAgentVersion;
    private final List<String> supportedInstanceFamilies;
    private final String dynamicAppProvidersEnabled;
    private final String imageSharedWithOthers;

    private Image(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.baseImageArn = builder.baseImageArn;
        this.displayName = builder.displayName;
        this.state = builder.state;
        this.visibility = builder.visibility;
        this.imageBuilderSupported = builder.imageBuilderSupported;
        this.imageBuilderName = builder.imageBuilderName;
        this.platform = builder.platform;
        this.description = builder.description;
        this.stateChangeReason = builder.stateChangeReason;
        this.applications = builder.applications;
        this.createdTime = builder.createdTime;
        this.publicBaseImageReleasedDate = builder.publicBaseImageReleasedDate;
        this.appstreamAgentVersion = builder.appstreamAgentVersion;
        this.imagePermissions = builder.imagePermissions;
        this.imageErrors = builder.imageErrors;
        this.latestAppstreamAgentVersion = builder.latestAppstreamAgentVersion;
        this.supportedInstanceFamilies = builder.supportedInstanceFamilies;
        this.dynamicAppProvidersEnabled = builder.dynamicAppProvidersEnabled;
        this.imageSharedWithOthers = builder.imageSharedWithOthers;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String baseImageArn() {
        return this.baseImageArn;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final ImageState state() {
        return ImageState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final VisibilityType visibility() {
        return VisibilityType.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final Boolean imageBuilderSupported() {
        return this.imageBuilderSupported;
    }

    public final String imageBuilderName() {
        return this.imageBuilderName;
    }

    public final PlatformType platform() {
        return PlatformType.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public final String description() {
        return this.description;
    }

    public final ImageStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public final boolean hasApplications() {
        return this.applications != null && !(this.applications instanceof SdkAutoConstructList);
    }

    public final List<Application> applications() {
        return this.applications;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant publicBaseImageReleasedDate() {
        return this.publicBaseImageReleasedDate;
    }

    public final String appstreamAgentVersion() {
        return this.appstreamAgentVersion;
    }

    public final ImagePermissions imagePermissions() {
        return this.imagePermissions;
    }

    public final boolean hasImageErrors() {
        return this.imageErrors != null && !(this.imageErrors instanceof SdkAutoConstructList);
    }

    public final List<ResourceError> imageErrors() {
        return this.imageErrors;
    }

    public final LatestAppstreamAgentVersion latestAppstreamAgentVersion() {
        return LatestAppstreamAgentVersion.fromValue(this.latestAppstreamAgentVersion);
    }

    public final String latestAppstreamAgentVersionAsString() {
        return this.latestAppstreamAgentVersion;
    }

    public final boolean hasSupportedInstanceFamilies() {
        return this.supportedInstanceFamilies != null && !(this.supportedInstanceFamilies instanceof SdkAutoConstructList);
    }

    public final List<String> supportedInstanceFamilies() {
        return this.supportedInstanceFamilies;
    }

    public final DynamicAppProvidersEnabled dynamicAppProvidersEnabled() {
        return DynamicAppProvidersEnabled.fromValue(this.dynamicAppProvidersEnabled);
    }

    public final String dynamicAppProvidersEnabledAsString() {
        return this.dynamicAppProvidersEnabled;
    }

    public final ImageSharedWithOthers imageSharedWithOthers() {
        return ImageSharedWithOthers.fromValue(this.imageSharedWithOthers);
    }

    public final String imageSharedWithOthersAsString() {
        return this.imageSharedWithOthers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseImageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBuilderSupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBuilderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplications() ? this.applications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicBaseImageReleasedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.appstreamAgentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageErrors() ? this.imageErrors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.latestAppstreamAgentVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedInstanceFamilies() ? this.supportedInstanceFamilies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicAppProvidersEnabledAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSharedWithOthersAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.baseImageArn(), other.baseImageArn()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.imageBuilderSupported(), other.imageBuilderSupported()) && Objects.equals(this.imageBuilderName(), other.imageBuilderName()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.stateChangeReason(), other.stateChangeReason()) && this.hasApplications() == other.hasApplications() && Objects.equals(this.applications(), other.applications()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.publicBaseImageReleasedDate(), other.publicBaseImageReleasedDate()) && Objects.equals(this.appstreamAgentVersion(), other.appstreamAgentVersion()) && Objects.equals(this.imagePermissions(), other.imagePermissions()) && this.hasImageErrors() == other.hasImageErrors() && Objects.equals(this.imageErrors(), other.imageErrors()) && Objects.equals(this.latestAppstreamAgentVersionAsString(), other.latestAppstreamAgentVersionAsString()) && this.hasSupportedInstanceFamilies() == other.hasSupportedInstanceFamilies() && Objects.equals(this.supportedInstanceFamilies(), other.supportedInstanceFamilies()) && Objects.equals(this.dynamicAppProvidersEnabledAsString(), other.dynamicAppProvidersEnabledAsString()) && Objects.equals(this.imageSharedWithOthersAsString(), other.imageSharedWithOthersAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Image").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("BaseImageArn", (Object)this.baseImageArn()).add("DisplayName", (Object)this.displayName()).add("State", (Object)this.stateAsString()).add("Visibility", (Object)this.visibilityAsString()).add("ImageBuilderSupported", (Object)this.imageBuilderSupported()).add("ImageBuilderName", (Object)this.imageBuilderName()).add("Platform", (Object)this.platformAsString()).add("Description", (Object)this.description()).add("StateChangeReason", (Object)this.stateChangeReason()).add("Applications", this.hasApplications() ? this.applications() : null).add("CreatedTime", (Object)this.createdTime()).add("PublicBaseImageReleasedDate", (Object)this.publicBaseImageReleasedDate()).add("AppstreamAgentVersion", (Object)this.appstreamAgentVersion()).add("ImagePermissions", (Object)this.imagePermissions()).add("ImageErrors", this.hasImageErrors() ? this.imageErrors() : null).add("LatestAppstreamAgentVersion", (Object)this.latestAppstreamAgentVersionAsString()).add("SupportedInstanceFamilies", this.hasSupportedInstanceFamilies() ? this.supportedInstanceFamilies() : null).add("DynamicAppProvidersEnabled", (Object)this.dynamicAppProvidersEnabledAsString()).add("ImageSharedWithOthers", (Object)this.imageSharedWithOthersAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "BaseImageArn": {
                return Optional.ofNullable(clazz.cast(this.baseImageArn()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "ImageBuilderSupported": {
                return Optional.ofNullable(clazz.cast(this.imageBuilderSupported()));
            }
            case "ImageBuilderName": {
                return Optional.ofNullable(clazz.cast(this.imageBuilderName()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "StateChangeReason": {
                return Optional.ofNullable(clazz.cast(this.stateChangeReason()));
            }
            case "Applications": {
                return Optional.ofNullable(clazz.cast(this.applications()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "PublicBaseImageReleasedDate": {
                return Optional.ofNullable(clazz.cast(this.publicBaseImageReleasedDate()));
            }
            case "AppstreamAgentVersion": {
                return Optional.ofNullable(clazz.cast(this.appstreamAgentVersion()));
            }
            case "ImagePermissions": {
                return Optional.ofNullable(clazz.cast(this.imagePermissions()));
            }
            case "ImageErrors": {
                return Optional.ofNullable(clazz.cast(this.imageErrors()));
            }
            case "LatestAppstreamAgentVersion": {
                return Optional.ofNullable(clazz.cast(this.latestAppstreamAgentVersionAsString()));
            }
            case "SupportedInstanceFamilies": {
                return Optional.ofNullable(clazz.cast(this.supportedInstanceFamilies()));
            }
            case "DynamicAppProvidersEnabled": {
                return Optional.ofNullable(clazz.cast(this.dynamicAppProvidersEnabledAsString()));
            }
            case "ImageSharedWithOthers": {
                return Optional.ofNullable(clazz.cast(this.imageSharedWithOthersAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("BaseImageArn", BASE_IMAGE_ARN_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        map.put("ImageBuilderSupported", IMAGE_BUILDER_SUPPORTED_FIELD);
        map.put("ImageBuilderName", IMAGE_BUILDER_NAME_FIELD);
        map.put("Platform", PLATFORM_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("StateChangeReason", STATE_CHANGE_REASON_FIELD);
        map.put("Applications", APPLICATIONS_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("PublicBaseImageReleasedDate", PUBLIC_BASE_IMAGE_RELEASED_DATE_FIELD);
        map.put("AppstreamAgentVersion", APPSTREAM_AGENT_VERSION_FIELD);
        map.put("ImagePermissions", IMAGE_PERMISSIONS_FIELD);
        map.put("ImageErrors", IMAGE_ERRORS_FIELD);
        map.put("LatestAppstreamAgentVersion", LATEST_APPSTREAM_AGENT_VERSION_FIELD);
        map.put("SupportedInstanceFamilies", SUPPORTED_INSTANCE_FAMILIES_FIELD);
        map.put("DynamicAppProvidersEnabled", DYNAMIC_APP_PROVIDERS_ENABLED_FIELD);
        map.put("ImageSharedWithOthers", IMAGE_SHARED_WITH_OTHERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Image, T> g) {
        return obj -> g.apply((Image)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String baseImageArn;
        private String displayName;
        private String state;
        private String visibility;
        private Boolean imageBuilderSupported;
        private String imageBuilderName;
        private String platform;
        private String description;
        private ImageStateChangeReason stateChangeReason;
        private List<Application> applications = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTime;
        private Instant publicBaseImageReleasedDate;
        private String appstreamAgentVersion;
        private ImagePermissions imagePermissions;
        private List<ResourceError> imageErrors = DefaultSdkAutoConstructList.getInstance();
        private String latestAppstreamAgentVersion;
        private List<String> supportedInstanceFamilies = DefaultSdkAutoConstructList.getInstance();
        private String dynamicAppProvidersEnabled;
        private String imageSharedWithOthers;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            this.name(model.name);
            this.arn(model.arn);
            this.baseImageArn(model.baseImageArn);
            this.displayName(model.displayName);
            this.state(model.state);
            this.visibility(model.visibility);
            this.imageBuilderSupported(model.imageBuilderSupported);
            this.imageBuilderName(model.imageBuilderName);
            this.platform(model.platform);
            this.description(model.description);
            this.stateChangeReason(model.stateChangeReason);
            this.applications(model.applications);
            this.createdTime(model.createdTime);
            this.publicBaseImageReleasedDate(model.publicBaseImageReleasedDate);
            this.appstreamAgentVersion(model.appstreamAgentVersion);
            this.imagePermissions(model.imagePermissions);
            this.imageErrors(model.imageErrors);
            this.latestAppstreamAgentVersion(model.latestAppstreamAgentVersion);
            this.supportedInstanceFamilies(model.supportedInstanceFamilies);
            this.dynamicAppProvidersEnabled(model.dynamicAppProvidersEnabled);
            this.imageSharedWithOthers(model.imageSharedWithOthers);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getBaseImageArn() {
            return this.baseImageArn;
        }

        public final void setBaseImageArn(String baseImageArn) {
            this.baseImageArn = baseImageArn;
        }

        @Override
        public final Builder baseImageArn(String baseImageArn) {
            this.baseImageArn = baseImageArn;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ImageState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(VisibilityType visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final Boolean getImageBuilderSupported() {
            return this.imageBuilderSupported;
        }

        public final void setImageBuilderSupported(Boolean imageBuilderSupported) {
            this.imageBuilderSupported = imageBuilderSupported;
        }

        @Override
        public final Builder imageBuilderSupported(Boolean imageBuilderSupported) {
            this.imageBuilderSupported = imageBuilderSupported;
            return this;
        }

        public final String getImageBuilderName() {
            return this.imageBuilderName;
        }

        public final void setImageBuilderName(String imageBuilderName) {
            this.imageBuilderName = imageBuilderName;
        }

        @Override
        public final Builder imageBuilderName(String imageBuilderName) {
            this.imageBuilderName = imageBuilderName;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformType platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ImageStateChangeReason.Builder getStateChangeReason() {
            return this.stateChangeReason != null ? this.stateChangeReason.toBuilder() : null;
        }

        public final void setStateChangeReason(ImageStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        @Override
        public final Builder stateChangeReason(ImageStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final List<Application.Builder> getApplications() {
            List<Application.Builder> result = ApplicationsCopier.copyToBuilder(this.applications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplications(Collection<Application.BuilderImpl> applications) {
            this.applications = ApplicationsCopier.copyFromBuilder(applications);
        }

        @Override
        public final Builder applications(Collection<Application> applications) {
            this.applications = ApplicationsCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Application ... applications) {
            this.applications(Arrays.asList(applications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Consumer<Application.Builder> ... applications) {
            this.applications(Stream.of(applications).map(c -> (Application)((Application.Builder)Application.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getPublicBaseImageReleasedDate() {
            return this.publicBaseImageReleasedDate;
        }

        public final void setPublicBaseImageReleasedDate(Instant publicBaseImageReleasedDate) {
            this.publicBaseImageReleasedDate = publicBaseImageReleasedDate;
        }

        @Override
        public final Builder publicBaseImageReleasedDate(Instant publicBaseImageReleasedDate) {
            this.publicBaseImageReleasedDate = publicBaseImageReleasedDate;
            return this;
        }

        public final String getAppstreamAgentVersion() {
            return this.appstreamAgentVersion;
        }

        public final void setAppstreamAgentVersion(String appstreamAgentVersion) {
            this.appstreamAgentVersion = appstreamAgentVersion;
        }

        @Override
        public final Builder appstreamAgentVersion(String appstreamAgentVersion) {
            this.appstreamAgentVersion = appstreamAgentVersion;
            return this;
        }

        public final ImagePermissions.Builder getImagePermissions() {
            return this.imagePermissions != null ? this.imagePermissions.toBuilder() : null;
        }

        public final void setImagePermissions(ImagePermissions.BuilderImpl imagePermissions) {
            this.imagePermissions = imagePermissions != null ? imagePermissions.build() : null;
        }

        @Override
        public final Builder imagePermissions(ImagePermissions imagePermissions) {
            this.imagePermissions = imagePermissions;
            return this;
        }

        public final List<ResourceError.Builder> getImageErrors() {
            List<ResourceError.Builder> result = ResourceErrorsCopier.copyToBuilder(this.imageErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageErrors(Collection<ResourceError.BuilderImpl> imageErrors) {
            this.imageErrors = ResourceErrorsCopier.copyFromBuilder(imageErrors);
        }

        @Override
        public final Builder imageErrors(Collection<ResourceError> imageErrors) {
            this.imageErrors = ResourceErrorsCopier.copy(imageErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageErrors(ResourceError ... imageErrors) {
            this.imageErrors(Arrays.asList(imageErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageErrors(Consumer<ResourceError.Builder> ... imageErrors) {
            this.imageErrors(Stream.of(imageErrors).map(c -> (ResourceError)((ResourceError.Builder)ResourceError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLatestAppstreamAgentVersion() {
            return this.latestAppstreamAgentVersion;
        }

        public final void setLatestAppstreamAgentVersion(String latestAppstreamAgentVersion) {
            this.latestAppstreamAgentVersion = latestAppstreamAgentVersion;
        }

        @Override
        public final Builder latestAppstreamAgentVersion(String latestAppstreamAgentVersion) {
            this.latestAppstreamAgentVersion = latestAppstreamAgentVersion;
            return this;
        }

        @Override
        public final Builder latestAppstreamAgentVersion(LatestAppstreamAgentVersion latestAppstreamAgentVersion) {
            this.latestAppstreamAgentVersion(latestAppstreamAgentVersion == null ? null : latestAppstreamAgentVersion.toString());
            return this;
        }

        public final Collection<String> getSupportedInstanceFamilies() {
            if (this.supportedInstanceFamilies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedInstanceFamilies;
        }

        public final void setSupportedInstanceFamilies(Collection<String> supportedInstanceFamilies) {
            this.supportedInstanceFamilies = StringListCopier.copy(supportedInstanceFamilies);
        }

        @Override
        public final Builder supportedInstanceFamilies(Collection<String> supportedInstanceFamilies) {
            this.supportedInstanceFamilies = StringListCopier.copy(supportedInstanceFamilies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedInstanceFamilies(String ... supportedInstanceFamilies) {
            this.supportedInstanceFamilies(Arrays.asList(supportedInstanceFamilies));
            return this;
        }

        public final String getDynamicAppProvidersEnabled() {
            return this.dynamicAppProvidersEnabled;
        }

        public final void setDynamicAppProvidersEnabled(String dynamicAppProvidersEnabled) {
            this.dynamicAppProvidersEnabled = dynamicAppProvidersEnabled;
        }

        @Override
        public final Builder dynamicAppProvidersEnabled(String dynamicAppProvidersEnabled) {
            this.dynamicAppProvidersEnabled = dynamicAppProvidersEnabled;
            return this;
        }

        @Override
        public final Builder dynamicAppProvidersEnabled(DynamicAppProvidersEnabled dynamicAppProvidersEnabled) {
            this.dynamicAppProvidersEnabled(dynamicAppProvidersEnabled == null ? null : dynamicAppProvidersEnabled.toString());
            return this;
        }

        public final String getImageSharedWithOthers() {
            return this.imageSharedWithOthers;
        }

        public final void setImageSharedWithOthers(String imageSharedWithOthers) {
            this.imageSharedWithOthers = imageSharedWithOthers;
        }

        @Override
        public final Builder imageSharedWithOthers(String imageSharedWithOthers) {
            this.imageSharedWithOthers = imageSharedWithOthers;
            return this;
        }

        @Override
        public final Builder imageSharedWithOthers(ImageSharedWithOthers imageSharedWithOthers) {
            this.imageSharedWithOthers(imageSharedWithOthers == null ? null : imageSharedWithOthers.toString());
            return this;
        }

        public Image build() {
            return new Image(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Image> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder baseImageArn(String var1);

        public Builder displayName(String var1);

        public Builder state(String var1);

        public Builder state(ImageState var1);

        public Builder visibility(String var1);

        public Builder visibility(VisibilityType var1);

        public Builder imageBuilderSupported(Boolean var1);

        public Builder imageBuilderName(String var1);

        public Builder platform(String var1);

        public Builder platform(PlatformType var1);

        public Builder description(String var1);

        public Builder stateChangeReason(ImageStateChangeReason var1);

        default public Builder stateChangeReason(Consumer<ImageStateChangeReason.Builder> stateChangeReason) {
            return this.stateChangeReason((ImageStateChangeReason)((ImageStateChangeReason.Builder)ImageStateChangeReason.builder().applyMutation(stateChangeReason)).build());
        }

        public Builder applications(Collection<Application> var1);

        public Builder applications(Application ... var1);

        public Builder applications(Consumer<Application.Builder> ... var1);

        public Builder createdTime(Instant var1);

        public Builder publicBaseImageReleasedDate(Instant var1);

        public Builder appstreamAgentVersion(String var1);

        public Builder imagePermissions(ImagePermissions var1);

        default public Builder imagePermissions(Consumer<ImagePermissions.Builder> imagePermissions) {
            return this.imagePermissions((ImagePermissions)((ImagePermissions.Builder)ImagePermissions.builder().applyMutation(imagePermissions)).build());
        }

        public Builder imageErrors(Collection<ResourceError> var1);

        public Builder imageErrors(ResourceError ... var1);

        public Builder imageErrors(Consumer<ResourceError.Builder> ... var1);

        public Builder latestAppstreamAgentVersion(String var1);

        public Builder latestAppstreamAgentVersion(LatestAppstreamAgentVersion var1);

        public Builder supportedInstanceFamilies(Collection<String> var1);

        public Builder supportedInstanceFamilies(String ... var1);

        public Builder dynamicAppProvidersEnabled(String var1);

        public Builder dynamicAppProvidersEnabled(DynamicAppProvidersEnabled var1);

        public Builder imageSharedWithOthers(String var1);

        public Builder imageSharedWithOthers(ImageSharedWithOthers var1);
    }
}

