/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.services.appstream.model.DirectoryConfig;
import software.amazon.awssdk.services.appstream.model.DirectoryConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDirectoryConfigsResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, DescribeDirectoryConfigsResponse> {
    private static final SdkField<List<DirectoryConfig>> DIRECTORY_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DirectoryConfigs").getter(DescribeDirectoryConfigsResponse.getter(DescribeDirectoryConfigsResponse::directoryConfigs)).setter(DescribeDirectoryConfigsResponse.setter(Builder::directoryConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DirectoryConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeDirectoryConfigsResponse.getter(DescribeDirectoryConfigsResponse::nextToken)).setter(DescribeDirectoryConfigsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_CONFIGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDirectoryConfigsResponse.memberNameToFieldInitializer();
    private final List<DirectoryConfig> directoryConfigs;
    private final String nextToken;

    private DescribeDirectoryConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.directoryConfigs = builder.directoryConfigs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDirectoryConfigs() {
        return this.directoryConfigs != null && !(this.directoryConfigs instanceof SdkAutoConstructList);
    }

    public final List<DirectoryConfig> directoryConfigs() {
        return this.directoryConfigs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDirectoryConfigs() ? this.directoryConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectoryConfigsResponse)) {
            return false;
        }
        DescribeDirectoryConfigsResponse other = (DescribeDirectoryConfigsResponse)((Object)obj);
        return this.hasDirectoryConfigs() == other.hasDirectoryConfigs() && Objects.equals(this.directoryConfigs(), other.directoryConfigs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDirectoryConfigsResponse").add("DirectoryConfigs", this.hasDirectoryConfigs() ? this.directoryConfigs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryConfigs": {
                return Optional.ofNullable(clazz.cast(this.directoryConfigs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DirectoryConfigs", DIRECTORY_CONFIGS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDirectoryConfigsResponse, T> g) {
        return obj -> g.apply((DescribeDirectoryConfigsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private List<DirectoryConfig> directoryConfigs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectoryConfigsResponse model) {
            super(model);
            this.directoryConfigs(model.directoryConfigs);
            this.nextToken(model.nextToken);
        }

        public final List<DirectoryConfig.Builder> getDirectoryConfigs() {
            List<DirectoryConfig.Builder> result = DirectoryConfigListCopier.copyToBuilder(this.directoryConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDirectoryConfigs(Collection<DirectoryConfig.BuilderImpl> directoryConfigs) {
            this.directoryConfigs = DirectoryConfigListCopier.copyFromBuilder(directoryConfigs);
        }

        @Override
        public final Builder directoryConfigs(Collection<DirectoryConfig> directoryConfigs) {
            this.directoryConfigs = DirectoryConfigListCopier.copy(directoryConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryConfigs(DirectoryConfig ... directoryConfigs) {
            this.directoryConfigs(Arrays.asList(directoryConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryConfigs(Consumer<DirectoryConfig.Builder> ... directoryConfigs) {
            this.directoryConfigs(Stream.of(directoryConfigs).map(c -> (DirectoryConfig)((DirectoryConfig.Builder)DirectoryConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDirectoryConfigsResponse build() {
            return new DescribeDirectoryConfigsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppStreamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDirectoryConfigsResponse> {
        public Builder directoryConfigs(Collection<DirectoryConfig> var1);

        public Builder directoryConfigs(DirectoryConfig ... var1);

        public Builder directoryConfigs(Consumer<DirectoryConfig.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

