/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceAccountCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceAccountCredentials> {
    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountName").getter(ServiceAccountCredentials.getter(ServiceAccountCredentials::accountName)).setter(ServiceAccountCredentials.setter(Builder::accountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountName").build()}).build();
    private static final SdkField<String> ACCOUNT_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountPassword").getter(ServiceAccountCredentials.getter(ServiceAccountCredentials::accountPassword)).setter(ServiceAccountCredentials.setter(Builder::accountPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountPassword").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_NAME_FIELD, ACCOUNT_PASSWORD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceAccountCredentials.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountName;
    private final String accountPassword;

    private ServiceAccountCredentials(BuilderImpl builder) {
        this.accountName = builder.accountName;
        this.accountPassword = builder.accountPassword;
    }

    public final String accountName() {
        return this.accountName;
    }

    public final String accountPassword() {
        return this.accountPassword;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountPassword());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceAccountCredentials)) {
            return false;
        }
        ServiceAccountCredentials other = (ServiceAccountCredentials)obj;
        return Objects.equals(this.accountName(), other.accountName()) && Objects.equals(this.accountPassword(), other.accountPassword());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceAccountCredentials").add("AccountName", (Object)(this.accountName() == null ? null : "*** Sensitive Data Redacted ***")).add("AccountPassword", (Object)(this.accountPassword() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountName": {
                return Optional.ofNullable(clazz.cast(this.accountName()));
            }
            case "AccountPassword": {
                return Optional.ofNullable(clazz.cast(this.accountPassword()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AccountName", ACCOUNT_NAME_FIELD);
        map.put("AccountPassword", ACCOUNT_PASSWORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceAccountCredentials, T> g) {
        return obj -> g.apply((ServiceAccountCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountName;
        private String accountPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceAccountCredentials model) {
            this.accountName(model.accountName);
            this.accountPassword(model.accountPassword);
        }

        public final String getAccountName() {
            return this.accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final String getAccountPassword() {
            return this.accountPassword;
        }

        public final void setAccountPassword(String accountPassword) {
            this.accountPassword = accountPassword;
        }

        @Override
        public final Builder accountPassword(String accountPassword) {
            this.accountPassword = accountPassword;
            return this;
        }

        public ServiceAccountCredentials build() {
            return new ServiceAccountCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceAccountCredentials> {
        public Builder accountName(String var1);

        public Builder accountPassword(String var1);
    }
}

