/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.PackagingType;
import software.amazon.awssdk.services.appstream.model.S3Location;
import software.amazon.awssdk.services.appstream.model.ScriptDetails;
import software.amazon.awssdk.services.appstream.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAppBlockRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, CreateAppBlockRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateAppBlockRequest.getter(CreateAppBlockRequest::name)).setter(CreateAppBlockRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateAppBlockRequest.getter(CreateAppBlockRequest::description)).setter(CreateAppBlockRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(CreateAppBlockRequest.getter(CreateAppBlockRequest::displayName)).setter(CreateAppBlockRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<S3Location> SOURCE_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceS3Location").getter(CreateAppBlockRequest.getter(CreateAppBlockRequest::sourceS3Location)).setter(CreateAppBlockRequest.setter(Builder::sourceS3Location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceS3Location").build()}).build();
    private static final SdkField<ScriptDetails> SETUP_SCRIPT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SetupScriptDetails").getter(CreateAppBlockRequest.getter(CreateAppBlockRequest::setupScriptDetails)).setter(CreateAppBlockRequest.setter(Builder::setupScriptDetails)).constructor(ScriptDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SetupScriptDetails").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateAppBlockRequest.getter(CreateAppBlockRequest::tags)).setter(CreateAppBlockRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ScriptDetails> POST_SETUP_SCRIPT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PostSetupScriptDetails").getter(CreateAppBlockRequest.getter(CreateAppBlockRequest::postSetupScriptDetails)).setter(CreateAppBlockRequest.setter(Builder::postSetupScriptDetails)).constructor(ScriptDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostSetupScriptDetails").build()}).build();
    private static final SdkField<String> PACKAGING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackagingType").getter(CreateAppBlockRequest.getter(CreateAppBlockRequest::packagingTypeAsString)).setter(CreateAppBlockRequest.setter(Builder::packagingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackagingType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, SOURCE_S3_LOCATION_FIELD, SETUP_SCRIPT_DETAILS_FIELD, TAGS_FIELD, POST_SETUP_SCRIPT_DETAILS_FIELD, PACKAGING_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAppBlockRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String displayName;
    private final S3Location sourceS3Location;
    private final ScriptDetails setupScriptDetails;
    private final Map<String, String> tags;
    private final ScriptDetails postSetupScriptDetails;
    private final String packagingType;

    private CreateAppBlockRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.sourceS3Location = builder.sourceS3Location;
        this.setupScriptDetails = builder.setupScriptDetails;
        this.tags = builder.tags;
        this.postSetupScriptDetails = builder.postSetupScriptDetails;
        this.packagingType = builder.packagingType;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final S3Location sourceS3Location() {
        return this.sourceS3Location;
    }

    public final ScriptDetails setupScriptDetails() {
        return this.setupScriptDetails;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ScriptDetails postSetupScriptDetails() {
        return this.postSetupScriptDetails;
    }

    public final PackagingType packagingType() {
        return PackagingType.fromValue(this.packagingType);
    }

    public final String packagingTypeAsString() {
        return this.packagingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.setupScriptDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.postSetupScriptDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.packagingTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppBlockRequest)) {
            return false;
        }
        CreateAppBlockRequest other = (CreateAppBlockRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.sourceS3Location(), other.sourceS3Location()) && Objects.equals(this.setupScriptDetails(), other.setupScriptDetails()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.postSetupScriptDetails(), other.postSetupScriptDetails()) && Objects.equals(this.packagingTypeAsString(), other.packagingTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAppBlockRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("SourceS3Location", (Object)this.sourceS3Location()).add("SetupScriptDetails", (Object)this.setupScriptDetails()).add("Tags", this.hasTags() ? this.tags() : null).add("PostSetupScriptDetails", (Object)this.postSetupScriptDetails()).add("PackagingType", (Object)this.packagingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "SourceS3Location": {
                return Optional.ofNullable(clazz.cast(this.sourceS3Location()));
            }
            case "SetupScriptDetails": {
                return Optional.ofNullable(clazz.cast(this.setupScriptDetails()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "PostSetupScriptDetails": {
                return Optional.ofNullable(clazz.cast(this.postSetupScriptDetails()));
            }
            case "PackagingType": {
                return Optional.ofNullable(clazz.cast(this.packagingTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("SourceS3Location", SOURCE_S3_LOCATION_FIELD);
        map.put("SetupScriptDetails", SETUP_SCRIPT_DETAILS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("PostSetupScriptDetails", POST_SETUP_SCRIPT_DETAILS_FIELD);
        map.put("PackagingType", PACKAGING_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAppBlockRequest, T> g) {
        return obj -> g.apply((CreateAppBlockRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String displayName;
        private S3Location sourceS3Location;
        private ScriptDetails setupScriptDetails;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private ScriptDetails postSetupScriptDetails;
        private String packagingType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppBlockRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.displayName(model.displayName);
            this.sourceS3Location(model.sourceS3Location);
            this.setupScriptDetails(model.setupScriptDetails);
            this.tags(model.tags);
            this.postSetupScriptDetails(model.postSetupScriptDetails);
            this.packagingType(model.packagingType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final S3Location.Builder getSourceS3Location() {
            return this.sourceS3Location != null ? this.sourceS3Location.toBuilder() : null;
        }

        public final void setSourceS3Location(S3Location.BuilderImpl sourceS3Location) {
            this.sourceS3Location = sourceS3Location != null ? sourceS3Location.build() : null;
        }

        @Override
        public final Builder sourceS3Location(S3Location sourceS3Location) {
            this.sourceS3Location = sourceS3Location;
            return this;
        }

        public final ScriptDetails.Builder getSetupScriptDetails() {
            return this.setupScriptDetails != null ? this.setupScriptDetails.toBuilder() : null;
        }

        public final void setSetupScriptDetails(ScriptDetails.BuilderImpl setupScriptDetails) {
            this.setupScriptDetails = setupScriptDetails != null ? setupScriptDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder setupScriptDetails(ScriptDetails setupScriptDetails) {
            this.setupScriptDetails = setupScriptDetails;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final ScriptDetails.Builder getPostSetupScriptDetails() {
            return this.postSetupScriptDetails != null ? this.postSetupScriptDetails.toBuilder() : null;
        }

        public final void setPostSetupScriptDetails(ScriptDetails.BuilderImpl postSetupScriptDetails) {
            this.postSetupScriptDetails = postSetupScriptDetails != null ? postSetupScriptDetails.build() : null;
        }

        @Override
        public final Builder postSetupScriptDetails(ScriptDetails postSetupScriptDetails) {
            this.postSetupScriptDetails = postSetupScriptDetails;
            return this;
        }

        public final String getPackagingType() {
            return this.packagingType;
        }

        public final void setPackagingType(String packagingType) {
            this.packagingType = packagingType;
        }

        @Override
        public final Builder packagingType(String packagingType) {
            this.packagingType = packagingType;
            return this;
        }

        @Override
        public final Builder packagingType(PackagingType packagingType) {
            this.packagingType(packagingType == null ? null : packagingType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppBlockRequest build() {
            return new CreateAppBlockRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAppBlockRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder sourceS3Location(S3Location var1);

        default public Builder sourceS3Location(Consumer<S3Location.Builder> sourceS3Location) {
            return this.sourceS3Location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(sourceS3Location)).build());
        }

        public Builder setupScriptDetails(ScriptDetails var1);

        default public Builder setupScriptDetails(Consumer<ScriptDetails.Builder> setupScriptDetails) {
            return this.setupScriptDetails((ScriptDetails)((ScriptDetails.Builder)ScriptDetails.builder().applyMutation(setupScriptDetails)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder postSetupScriptDetails(ScriptDetails var1);

        default public Builder postSetupScriptDetails(Consumer<ScriptDetails.Builder> postSetupScriptDetails) {
            return this.postSetupScriptDetails((ScriptDetails)((ScriptDetails.Builder)ScriptDetails.builder().applyMutation(postSetupScriptDetails)).build());
        }

        public Builder packagingType(String var1);

        public Builder packagingType(PackagingType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

