/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateApplicationToEntitlementRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, AssociateApplicationToEntitlementRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(AssociateApplicationToEntitlementRequest.getter(AssociateApplicationToEntitlementRequest::stackName)).setter(AssociateApplicationToEntitlementRequest.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> ENTITLEMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntitlementName").getter(AssociateApplicationToEntitlementRequest.getter(AssociateApplicationToEntitlementRequest::entitlementName)).setter(AssociateApplicationToEntitlementRequest.setter(Builder::entitlementName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntitlementName").build()}).build();
    private static final SdkField<String> APPLICATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationIdentifier").getter(AssociateApplicationToEntitlementRequest.getter(AssociateApplicationToEntitlementRequest::applicationIdentifier)).setter(AssociateApplicationToEntitlementRequest.setter(Builder::applicationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD, ENTITLEMENT_NAME_FIELD, APPLICATION_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateApplicationToEntitlementRequest.memberNameToFieldInitializer();
    private final String stackName;
    private final String entitlementName;
    private final String applicationIdentifier;

    private AssociateApplicationToEntitlementRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.entitlementName = builder.entitlementName;
        this.applicationIdentifier = builder.applicationIdentifier;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final String entitlementName() {
        return this.entitlementName;
    }

    public final String applicationIdentifier() {
        return this.applicationIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.entitlementName());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateApplicationToEntitlementRequest)) {
            return false;
        }
        AssociateApplicationToEntitlementRequest other = (AssociateApplicationToEntitlementRequest)((Object)obj);
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.entitlementName(), other.entitlementName()) && Objects.equals(this.applicationIdentifier(), other.applicationIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateApplicationToEntitlementRequest").add("StackName", (Object)this.stackName()).add("EntitlementName", (Object)this.entitlementName()).add("ApplicationIdentifier", (Object)this.applicationIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "EntitlementName": {
                return Optional.ofNullable(clazz.cast(this.entitlementName()));
            }
            case "ApplicationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.applicationIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("StackName", STACK_NAME_FIELD);
        map.put("EntitlementName", ENTITLEMENT_NAME_FIELD);
        map.put("ApplicationIdentifier", APPLICATION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateApplicationToEntitlementRequest, T> g) {
        return obj -> g.apply((AssociateApplicationToEntitlementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String stackName;
        private String entitlementName;
        private String applicationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateApplicationToEntitlementRequest model) {
            super(model);
            this.stackName(model.stackName);
            this.entitlementName(model.entitlementName);
            this.applicationIdentifier(model.applicationIdentifier);
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getEntitlementName() {
            return this.entitlementName;
        }

        public final void setEntitlementName(String entitlementName) {
            this.entitlementName = entitlementName;
        }

        @Override
        public final Builder entitlementName(String entitlementName) {
            this.entitlementName = entitlementName;
            return this;
        }

        public final String getApplicationIdentifier() {
            return this.applicationIdentifier;
        }

        public final void setApplicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
        }

        @Override
        public final Builder applicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateApplicationToEntitlementRequest build() {
            return new AssociateApplicationToEntitlementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateApplicationToEntitlementRequest> {
        public Builder stackName(String var1);

        public Builder entitlementName(String var1);

        public Builder applicationIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

