/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApplicationAttribute {
    LAUNCH_PARAMETERS("LAUNCH_PARAMETERS"),
    WORKING_DIRECTORY("WORKING_DIRECTORY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApplicationAttribute> VALUE_MAP;
    private final String value;

    private ApplicationAttribute(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApplicationAttribute fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApplicationAttribute> knownValues() {
        EnumSet<ApplicationAttribute> knownValues = EnumSet.allOf(ApplicationAttribute.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApplicationAttribute.class, ApplicationAttribute::toString);
    }
}

