/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appstream.model.AuthenticationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserStackAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserStackAssociation> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UserStackAssociation.getter(UserStackAssociation::stackName)).setter(UserStackAssociation.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UserStackAssociation.getter(UserStackAssociation::userName)).setter(UserStackAssociation.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UserStackAssociation.getter(UserStackAssociation::authenticationTypeAsString)).setter(UserStackAssociation.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build()}).build();
    private static final SdkField<Boolean> SEND_EMAIL_NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UserStackAssociation.getter(UserStackAssociation::sendEmailNotification)).setter(UserStackAssociation.setter(Builder::sendEmailNotification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendEmailNotification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD, USER_NAME_FIELD, AUTHENTICATION_TYPE_FIELD, SEND_EMAIL_NOTIFICATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stackName;
    private final String userName;
    private final String authenticationType;
    private final Boolean sendEmailNotification;

    private UserStackAssociation(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.userName = builder.userName;
        this.authenticationType = builder.authenticationType;
        this.sendEmailNotification = builder.sendEmailNotification;
    }

    public String stackName() {
        return this.stackName;
    }

    public String userName() {
        return this.userName;
    }

    public AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(this.authenticationType);
    }

    public String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public Boolean sendEmailNotification() {
        return this.sendEmailNotification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sendEmailNotification());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserStackAssociation)) {
            return false;
        }
        UserStackAssociation other = (UserStackAssociation)obj;
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.sendEmailNotification(), other.sendEmailNotification());
    }

    public String toString() {
        return ToString.builder((String)"UserStackAssociation").add("StackName", (Object)this.stackName()).add("UserName", (Object)this.userName()).add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("SendEmailNotification", (Object)this.sendEmailNotification()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "AuthenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "SendEmailNotification": {
                return Optional.ofNullable(clazz.cast(this.sendEmailNotification()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserStackAssociation, T> g) {
        return obj -> g.apply((UserStackAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackName;
        private String userName;
        private String authenticationType;
        private Boolean sendEmailNotification;

        private BuilderImpl() {
        }

        private BuilderImpl(UserStackAssociation model) {
            this.stackName(model.stackName);
            this.userName(model.userName);
            this.authenticationType(model.authenticationType);
            this.sendEmailNotification(model.sendEmailNotification);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getAuthenticationTypeAsString() {
            return this.authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType.toString());
            return this;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        public final Boolean getSendEmailNotification() {
            return this.sendEmailNotification;
        }

        @Override
        public final Builder sendEmailNotification(Boolean sendEmailNotification) {
            this.sendEmailNotification = sendEmailNotification;
            return this;
        }

        public final void setSendEmailNotification(Boolean sendEmailNotification) {
            this.sendEmailNotification = sendEmailNotification;
        }

        public UserStackAssociation build() {
            return new UserStackAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserStackAssociation> {
        public Builder stackName(String var1);

        public Builder userName(String var1);

        public Builder authenticationType(String var1);

        public Builder authenticationType(AuthenticationType var1);

        public Builder sendEmailNotification(Boolean var1);
    }
}

