/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AccessEndpoint;
import software.amazon.awssdk.services.appstream.model.AccessEndpointListCopier;
import software.amazon.awssdk.services.appstream.model.ApplicationSettingsResponse;
import software.amazon.awssdk.services.appstream.model.EmbedHostDomainsCopier;
import software.amazon.awssdk.services.appstream.model.StackError;
import software.amazon.awssdk.services.appstream.model.StackErrorsCopier;
import software.amazon.awssdk.services.appstream.model.StorageConnector;
import software.amazon.awssdk.services.appstream.model.StorageConnectorListCopier;
import software.amazon.awssdk.services.appstream.model.StreamingExperienceSettings;
import software.amazon.awssdk.services.appstream.model.UserSetting;
import software.amazon.awssdk.services.appstream.model.UserSettingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Stack
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Stack> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Stack.getter(Stack::arn)).setter(Stack.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Stack.getter(Stack::name)).setter(Stack.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Stack.getter(Stack::description)).setter(Stack.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(Stack.getter(Stack::displayName)).setter(Stack.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(Stack.getter(Stack::createdTime)).setter(Stack.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<List<StorageConnector>> STORAGE_CONNECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StorageConnectors").getter(Stack.getter(Stack::storageConnectors)).setter(Stack.setter(Builder::storageConnectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageConnectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StorageConnector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REDIRECT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedirectURL").getter(Stack.getter(Stack::redirectURL)).setter(Stack.setter(Builder::redirectURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectURL").build()}).build();
    private static final SdkField<String> FEEDBACK_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeedbackURL").getter(Stack.getter(Stack::feedbackURL)).setter(Stack.setter(Builder::feedbackURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackURL").build()}).build();
    private static final SdkField<List<StackError>> STACK_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackErrors").getter(Stack.getter(Stack::stackErrors)).setter(Stack.setter(Builder::stackErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StackError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UserSetting>> USER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserSettings").getter(Stack.getter(Stack::userSettings)).setter(Stack.setter(Builder::userSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ApplicationSettingsResponse> APPLICATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationSettings").getter(Stack.getter(Stack::applicationSettings)).setter(Stack.setter(Builder::applicationSettings)).constructor(ApplicationSettingsResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSettings").build()}).build();
    private static final SdkField<List<AccessEndpoint>> ACCESS_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessEndpoints").getter(Stack.getter(Stack::accessEndpoints)).setter(Stack.setter(Builder::accessEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EMBED_HOST_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EmbedHostDomains").getter(Stack.getter(Stack::embedHostDomains)).setter(Stack.setter(Builder::embedHostDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmbedHostDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StreamingExperienceSettings> STREAMING_EXPERIENCE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamingExperienceSettings").getter(Stack.getter(Stack::streamingExperienceSettings)).setter(Stack.setter(Builder::streamingExperienceSettings)).constructor(StreamingExperienceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingExperienceSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, CREATED_TIME_FIELD, STORAGE_CONNECTORS_FIELD, REDIRECT_URL_FIELD, FEEDBACK_URL_FIELD, STACK_ERRORS_FIELD, USER_SETTINGS_FIELD, APPLICATION_SETTINGS_FIELD, ACCESS_ENDPOINTS_FIELD, EMBED_HOST_DOMAINS_FIELD, STREAMING_EXPERIENCE_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("DisplayName", DISPLAY_NAME_FIELD);
            this.put("CreatedTime", CREATED_TIME_FIELD);
            this.put("StorageConnectors", STORAGE_CONNECTORS_FIELD);
            this.put("RedirectURL", REDIRECT_URL_FIELD);
            this.put("FeedbackURL", FEEDBACK_URL_FIELD);
            this.put("StackErrors", STACK_ERRORS_FIELD);
            this.put("UserSettings", USER_SETTINGS_FIELD);
            this.put("ApplicationSettings", APPLICATION_SETTINGS_FIELD);
            this.put("AccessEndpoints", ACCESS_ENDPOINTS_FIELD);
            this.put("EmbedHostDomains", EMBED_HOST_DOMAINS_FIELD);
            this.put("StreamingExperienceSettings", STREAMING_EXPERIENCE_SETTINGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String description;
    private final String displayName;
    private final Instant createdTime;
    private final List<StorageConnector> storageConnectors;
    private final String redirectURL;
    private final String feedbackURL;
    private final List<StackError> stackErrors;
    private final List<UserSetting> userSettings;
    private final ApplicationSettingsResponse applicationSettings;
    private final List<AccessEndpoint> accessEndpoints;
    private final List<String> embedHostDomains;
    private final StreamingExperienceSettings streamingExperienceSettings;

    private Stack(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.createdTime = builder.createdTime;
        this.storageConnectors = builder.storageConnectors;
        this.redirectURL = builder.redirectURL;
        this.feedbackURL = builder.feedbackURL;
        this.stackErrors = builder.stackErrors;
        this.userSettings = builder.userSettings;
        this.applicationSettings = builder.applicationSettings;
        this.accessEndpoints = builder.accessEndpoints;
        this.embedHostDomains = builder.embedHostDomains;
        this.streamingExperienceSettings = builder.streamingExperienceSettings;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final boolean hasStorageConnectors() {
        return this.storageConnectors != null && !(this.storageConnectors instanceof SdkAutoConstructList);
    }

    public final List<StorageConnector> storageConnectors() {
        return this.storageConnectors;
    }

    public final String redirectURL() {
        return this.redirectURL;
    }

    public final String feedbackURL() {
        return this.feedbackURL;
    }

    public final boolean hasStackErrors() {
        return this.stackErrors != null && !(this.stackErrors instanceof SdkAutoConstructList);
    }

    public final List<StackError> stackErrors() {
        return this.stackErrors;
    }

    public final boolean hasUserSettings() {
        return this.userSettings != null && !(this.userSettings instanceof SdkAutoConstructList);
    }

    public final List<UserSetting> userSettings() {
        return this.userSettings;
    }

    public final ApplicationSettingsResponse applicationSettings() {
        return this.applicationSettings;
    }

    public final boolean hasAccessEndpoints() {
        return this.accessEndpoints != null && !(this.accessEndpoints instanceof SdkAutoConstructList);
    }

    public final List<AccessEndpoint> accessEndpoints() {
        return this.accessEndpoints;
    }

    public final boolean hasEmbedHostDomains() {
        return this.embedHostDomains != null && !(this.embedHostDomains instanceof SdkAutoConstructList);
    }

    public final List<String> embedHostDomains() {
        return this.embedHostDomains;
    }

    public final StreamingExperienceSettings streamingExperienceSettings() {
        return this.streamingExperienceSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageConnectors() ? this.storageConnectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackErrors() ? this.stackErrors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserSettings() ? this.userSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessEndpoints() ? this.accessEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmbedHostDomains() ? this.embedHostDomains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingExperienceSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stack)) {
            return false;
        }
        Stack other = (Stack)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.createdTime(), other.createdTime()) && this.hasStorageConnectors() == other.hasStorageConnectors() && Objects.equals(this.storageConnectors(), other.storageConnectors()) && Objects.equals(this.redirectURL(), other.redirectURL()) && Objects.equals(this.feedbackURL(), other.feedbackURL()) && this.hasStackErrors() == other.hasStackErrors() && Objects.equals(this.stackErrors(), other.stackErrors()) && this.hasUserSettings() == other.hasUserSettings() && Objects.equals(this.userSettings(), other.userSettings()) && Objects.equals(this.applicationSettings(), other.applicationSettings()) && this.hasAccessEndpoints() == other.hasAccessEndpoints() && Objects.equals(this.accessEndpoints(), other.accessEndpoints()) && this.hasEmbedHostDomains() == other.hasEmbedHostDomains() && Objects.equals(this.embedHostDomains(), other.embedHostDomains()) && Objects.equals(this.streamingExperienceSettings(), other.streamingExperienceSettings());
    }

    public final String toString() {
        return ToString.builder((String)"Stack").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("CreatedTime", (Object)this.createdTime()).add("StorageConnectors", this.hasStorageConnectors() ? this.storageConnectors() : null).add("RedirectURL", (Object)this.redirectURL()).add("FeedbackURL", (Object)this.feedbackURL()).add("StackErrors", this.hasStackErrors() ? this.stackErrors() : null).add("UserSettings", this.hasUserSettings() ? this.userSettings() : null).add("ApplicationSettings", (Object)this.applicationSettings()).add("AccessEndpoints", this.hasAccessEndpoints() ? this.accessEndpoints() : null).add("EmbedHostDomains", this.hasEmbedHostDomains() ? this.embedHostDomains() : null).add("StreamingExperienceSettings", (Object)this.streamingExperienceSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "StorageConnectors": {
                return Optional.ofNullable(clazz.cast(this.storageConnectors()));
            }
            case "RedirectURL": {
                return Optional.ofNullable(clazz.cast(this.redirectURL()));
            }
            case "FeedbackURL": {
                return Optional.ofNullable(clazz.cast(this.feedbackURL()));
            }
            case "StackErrors": {
                return Optional.ofNullable(clazz.cast(this.stackErrors()));
            }
            case "UserSettings": {
                return Optional.ofNullable(clazz.cast(this.userSettings()));
            }
            case "ApplicationSettings": {
                return Optional.ofNullable(clazz.cast(this.applicationSettings()));
            }
            case "AccessEndpoints": {
                return Optional.ofNullable(clazz.cast(this.accessEndpoints()));
            }
            case "EmbedHostDomains": {
                return Optional.ofNullable(clazz.cast(this.embedHostDomains()));
            }
            case "StreamingExperienceSettings": {
                return Optional.ofNullable(clazz.cast(this.streamingExperienceSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Stack, T> g) {
        return obj -> g.apply((Stack)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private String displayName;
        private Instant createdTime;
        private List<StorageConnector> storageConnectors = DefaultSdkAutoConstructList.getInstance();
        private String redirectURL;
        private String feedbackURL;
        private List<StackError> stackErrors = DefaultSdkAutoConstructList.getInstance();
        private List<UserSetting> userSettings = DefaultSdkAutoConstructList.getInstance();
        private ApplicationSettingsResponse applicationSettings;
        private List<AccessEndpoint> accessEndpoints = DefaultSdkAutoConstructList.getInstance();
        private List<String> embedHostDomains = DefaultSdkAutoConstructList.getInstance();
        private StreamingExperienceSettings streamingExperienceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(Stack model) {
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.displayName(model.displayName);
            this.createdTime(model.createdTime);
            this.storageConnectors(model.storageConnectors);
            this.redirectURL(model.redirectURL);
            this.feedbackURL(model.feedbackURL);
            this.stackErrors(model.stackErrors);
            this.userSettings(model.userSettings);
            this.applicationSettings(model.applicationSettings);
            this.accessEndpoints(model.accessEndpoints);
            this.embedHostDomains(model.embedHostDomains);
            this.streamingExperienceSettings(model.streamingExperienceSettings);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final List<StorageConnector.Builder> getStorageConnectors() {
            List<StorageConnector.Builder> result = StorageConnectorListCopier.copyToBuilder(this.storageConnectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageConnectors(Collection<StorageConnector.BuilderImpl> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copyFromBuilder(storageConnectors);
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector ... storageConnectors) {
            this.storageConnectors(Arrays.asList(storageConnectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(Consumer<StorageConnector.Builder> ... storageConnectors) {
            this.storageConnectors(Stream.of(storageConnectors).map(c -> (StorageConnector)((StorageConnector.Builder)StorageConnector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRedirectURL() {
            return this.redirectURL;
        }

        public final void setRedirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
        }

        @Override
        public final Builder redirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
            return this;
        }

        public final String getFeedbackURL() {
            return this.feedbackURL;
        }

        public final void setFeedbackURL(String feedbackURL) {
            this.feedbackURL = feedbackURL;
        }

        @Override
        public final Builder feedbackURL(String feedbackURL) {
            this.feedbackURL = feedbackURL;
            return this;
        }

        public final List<StackError.Builder> getStackErrors() {
            List<StackError.Builder> result = StackErrorsCopier.copyToBuilder(this.stackErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStackErrors(Collection<StackError.BuilderImpl> stackErrors) {
            this.stackErrors = StackErrorsCopier.copyFromBuilder(stackErrors);
        }

        @Override
        public final Builder stackErrors(Collection<StackError> stackErrors) {
            this.stackErrors = StackErrorsCopier.copy(stackErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackErrors(StackError ... stackErrors) {
            this.stackErrors(Arrays.asList(stackErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackErrors(Consumer<StackError.Builder> ... stackErrors) {
            this.stackErrors(Stream.of(stackErrors).map(c -> (StackError)((StackError.Builder)StackError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UserSetting.Builder> getUserSettings() {
            List<UserSetting.Builder> result = UserSettingListCopier.copyToBuilder(this.userSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserSettings(Collection<UserSetting.BuilderImpl> userSettings) {
            this.userSettings = UserSettingListCopier.copyFromBuilder(userSettings);
        }

        @Override
        public final Builder userSettings(Collection<UserSetting> userSettings) {
            this.userSettings = UserSettingListCopier.copy(userSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(UserSetting ... userSettings) {
            this.userSettings(Arrays.asList(userSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(Consumer<UserSetting.Builder> ... userSettings) {
            this.userSettings(Stream.of(userSettings).map(c -> (UserSetting)((UserSetting.Builder)UserSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ApplicationSettingsResponse.Builder getApplicationSettings() {
            return this.applicationSettings != null ? this.applicationSettings.toBuilder() : null;
        }

        public final void setApplicationSettings(ApplicationSettingsResponse.BuilderImpl applicationSettings) {
            this.applicationSettings = applicationSettings != null ? applicationSettings.build() : null;
        }

        @Override
        public final Builder applicationSettings(ApplicationSettingsResponse applicationSettings) {
            this.applicationSettings = applicationSettings;
            return this;
        }

        public final List<AccessEndpoint.Builder> getAccessEndpoints() {
            List<AccessEndpoint.Builder> result = AccessEndpointListCopier.copyToBuilder(this.accessEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessEndpoints(Collection<AccessEndpoint.BuilderImpl> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copyFromBuilder(accessEndpoints);
        }

        @Override
        public final Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copy(accessEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(AccessEndpoint ... accessEndpoints) {
            this.accessEndpoints(Arrays.asList(accessEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(Consumer<AccessEndpoint.Builder> ... accessEndpoints) {
            this.accessEndpoints(Stream.of(accessEndpoints).map(c -> (AccessEndpoint)((AccessEndpoint.Builder)AccessEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getEmbedHostDomains() {
            if (this.embedHostDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.embedHostDomains;
        }

        public final void setEmbedHostDomains(Collection<String> embedHostDomains) {
            this.embedHostDomains = EmbedHostDomainsCopier.copy(embedHostDomains);
        }

        @Override
        public final Builder embedHostDomains(Collection<String> embedHostDomains) {
            this.embedHostDomains = EmbedHostDomainsCopier.copy(embedHostDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder embedHostDomains(String ... embedHostDomains) {
            this.embedHostDomains(Arrays.asList(embedHostDomains));
            return this;
        }

        public final StreamingExperienceSettings.Builder getStreamingExperienceSettings() {
            return this.streamingExperienceSettings != null ? this.streamingExperienceSettings.toBuilder() : null;
        }

        public final void setStreamingExperienceSettings(StreamingExperienceSettings.BuilderImpl streamingExperienceSettings) {
            this.streamingExperienceSettings = streamingExperienceSettings != null ? streamingExperienceSettings.build() : null;
        }

        @Override
        public final Builder streamingExperienceSettings(StreamingExperienceSettings streamingExperienceSettings) {
            this.streamingExperienceSettings = streamingExperienceSettings;
            return this;
        }

        public Stack build() {
            return new Stack(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Stack> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder createdTime(Instant var1);

        public Builder storageConnectors(Collection<StorageConnector> var1);

        public Builder storageConnectors(StorageConnector ... var1);

        public Builder storageConnectors(Consumer<StorageConnector.Builder> ... var1);

        public Builder redirectURL(String var1);

        public Builder feedbackURL(String var1);

        public Builder stackErrors(Collection<StackError> var1);

        public Builder stackErrors(StackError ... var1);

        public Builder stackErrors(Consumer<StackError.Builder> ... var1);

        public Builder userSettings(Collection<UserSetting> var1);

        public Builder userSettings(UserSetting ... var1);

        public Builder userSettings(Consumer<UserSetting.Builder> ... var1);

        public Builder applicationSettings(ApplicationSettingsResponse var1);

        default public Builder applicationSettings(Consumer<ApplicationSettingsResponse.Builder> applicationSettings) {
            return this.applicationSettings((ApplicationSettingsResponse)((ApplicationSettingsResponse.Builder)ApplicationSettingsResponse.builder().applyMutation(applicationSettings)).build());
        }

        public Builder accessEndpoints(Collection<AccessEndpoint> var1);

        public Builder accessEndpoints(AccessEndpoint ... var1);

        public Builder accessEndpoints(Consumer<AccessEndpoint.Builder> ... var1);

        public Builder embedHostDomains(Collection<String> var1);

        public Builder embedHostDomains(String ... var1);

        public Builder streamingExperienceSettings(StreamingExperienceSettings var1);

        default public Builder streamingExperienceSettings(Consumer<StreamingExperienceSettings.Builder> streamingExperienceSettings) {
            return this.streamingExperienceSettings((StreamingExperienceSettings)((StreamingExperienceSettings.Builder)StreamingExperienceSettings.builder().applyMutation(streamingExperienceSettings)).build());
        }
    }
}

