/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.ImageBuilder;

final class ImageBuilderListCopier {
    ImageBuilderListCopier() {
    }

    static List<ImageBuilder> copy(Collection<? extends ImageBuilder> imageBuilderListParam) {
        Object list;
        if (imageBuilderListParam == null || imageBuilderListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            imageBuilderListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ImageBuilder> copyFromBuilder(Collection<? extends ImageBuilder.Builder> imageBuilderListParam) {
        Object list;
        if (imageBuilderListParam == null || imageBuilderListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            imageBuilderListParam.forEach(entry -> {
                ImageBuilder member = entry == null ? null : (ImageBuilder)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ImageBuilder.Builder> copyToBuilder(Collection<? extends ImageBuilder> imageBuilderListParam) {
        Object list;
        if (imageBuilderListParam == null || imageBuilderListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            imageBuilderListParam.forEach(entry -> {
                ImageBuilder.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

