/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAppBlockBuilderAppBlockAssociationsRequest extends AppStreamRequest
        implements
        ToCopyableBuilder<DescribeAppBlockBuilderAppBlockAssociationsRequest.Builder, DescribeAppBlockBuilderAppBlockAssociationsRequest> {
    private static final SdkField<String> APP_BLOCK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppBlockArn").getter(getter(DescribeAppBlockBuilderAppBlockAssociationsRequest::appBlockArn))
            .setter(setter(Builder::appBlockArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBlockArn").build()).build();

    private static final SdkField<String> APP_BLOCK_BUILDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppBlockBuilderName")
            .getter(getter(DescribeAppBlockBuilderAppBlockAssociationsRequest::appBlockBuilderName))
            .setter(setter(Builder::appBlockBuilderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBlockBuilderName").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeAppBlockBuilderAppBlockAssociationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeAppBlockBuilderAppBlockAssociationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BLOCK_ARN_FIELD,
            APP_BLOCK_BUILDER_NAME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String appBlockArn;

    private final String appBlockBuilderName;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeAppBlockBuilderAppBlockAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.appBlockArn = builder.appBlockArn;
        this.appBlockBuilderName = builder.appBlockBuilderName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ARN of the app block.
     * </p>
     * 
     * @return The ARN of the app block.
     */
    public final String appBlockArn() {
        return appBlockArn;
    }

    /**
     * <p>
     * The name of the app block builder.
     * </p>
     * 
     * @return The name of the app block builder.
     */
    public final String appBlockBuilderName() {
        return appBlockBuilderName;
    }

    /**
     * <p>
     * The maximum size of each page of results.
     * </p>
     * 
     * @return The maximum size of each page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation.
     * </p>
     * 
     * @return The pagination token used to retrieve the next page of results for this operation.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appBlockArn());
        hashCode = 31 * hashCode + Objects.hashCode(appBlockBuilderName());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppBlockBuilderAppBlockAssociationsRequest)) {
            return false;
        }
        DescribeAppBlockBuilderAppBlockAssociationsRequest other = (DescribeAppBlockBuilderAppBlockAssociationsRequest) obj;
        return Objects.equals(appBlockArn(), other.appBlockArn())
                && Objects.equals(appBlockBuilderName(), other.appBlockBuilderName())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAppBlockBuilderAppBlockAssociationsRequest").add("AppBlockArn", appBlockArn())
                .add("AppBlockBuilderName", appBlockBuilderName()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppBlockArn":
            return Optional.ofNullable(clazz.cast(appBlockArn()));
        case "AppBlockBuilderName":
            return Optional.ofNullable(clazz.cast(appBlockBuilderName()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppBlockBuilderAppBlockAssociationsRequest, T> g) {
        return obj -> g.apply((DescribeAppBlockBuilderAppBlockAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAppBlockBuilderAppBlockAssociationsRequest> {
        /**
         * <p>
         * The ARN of the app block.
         * </p>
         * 
         * @param appBlockArn
         *        The ARN of the app block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appBlockArn(String appBlockArn);

        /**
         * <p>
         * The name of the app block builder.
         * </p>
         * 
         * @param appBlockBuilderName
         *        The name of the app block builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appBlockBuilderName(String appBlockBuilderName);

        /**
         * <p>
         * The maximum size of each page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum size of each page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token used to retrieve the next page of results for this operation.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used to retrieve the next page of results for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String appBlockArn;

        private String appBlockBuilderName;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppBlockBuilderAppBlockAssociationsRequest model) {
            super(model);
            appBlockArn(model.appBlockArn);
            appBlockBuilderName(model.appBlockBuilderName);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getAppBlockArn() {
            return appBlockArn;
        }

        public final void setAppBlockArn(String appBlockArn) {
            this.appBlockArn = appBlockArn;
        }

        @Override
        public final Builder appBlockArn(String appBlockArn) {
            this.appBlockArn = appBlockArn;
            return this;
        }

        public final String getAppBlockBuilderName() {
            return appBlockBuilderName;
        }

        public final void setAppBlockBuilderName(String appBlockBuilderName) {
            this.appBlockBuilderName = appBlockBuilderName;
        }

        @Override
        public final Builder appBlockBuilderName(String appBlockBuilderName) {
            this.appBlockBuilderName = appBlockBuilderName;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAppBlockBuilderAppBlockAssociationsRequest build() {
            return new DescribeAppBlockBuilderAppBlockAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
