/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.services.appstream.model.ImageBuilder;
import software.amazon.awssdk.services.appstream.model.ImageBuilderListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImageBuildersResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, DescribeImageBuildersResponse> {
    private static final SdkField<List<ImageBuilder>> IMAGE_BUILDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImageBuilders").getter(DescribeImageBuildersResponse.getter(DescribeImageBuildersResponse::imageBuilders)).setter(DescribeImageBuildersResponse.setter(Builder::imageBuilders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageBuilders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageBuilder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeImageBuildersResponse.getter(DescribeImageBuildersResponse::nextToken)).setter(DescribeImageBuildersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_BUILDERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ImageBuilder> imageBuilders;
    private final String nextToken;

    private DescribeImageBuildersResponse(BuilderImpl builder) {
        super(builder);
        this.imageBuilders = builder.imageBuilders;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasImageBuilders() {
        return this.imageBuilders != null && !(this.imageBuilders instanceof SdkAutoConstructList);
    }

    public final List<ImageBuilder> imageBuilders() {
        return this.imageBuilders;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageBuilders() ? this.imageBuilders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageBuildersResponse)) {
            return false;
        }
        DescribeImageBuildersResponse other = (DescribeImageBuildersResponse)((Object)obj);
        return this.hasImageBuilders() == other.hasImageBuilders() && Objects.equals(this.imageBuilders(), other.imageBuilders()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImageBuildersResponse").add("ImageBuilders", this.hasImageBuilders() ? this.imageBuilders() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageBuilders": {
                return Optional.ofNullable(clazz.cast(this.imageBuilders()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageBuildersResponse, T> g) {
        return obj -> g.apply((DescribeImageBuildersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private List<ImageBuilder> imageBuilders = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageBuildersResponse model) {
            super(model);
            this.imageBuilders(model.imageBuilders);
            this.nextToken(model.nextToken);
        }

        public final List<ImageBuilder.Builder> getImageBuilders() {
            List<ImageBuilder.Builder> result = ImageBuilderListCopier.copyToBuilder(this.imageBuilders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageBuilders(Collection<ImageBuilder.BuilderImpl> imageBuilders) {
            this.imageBuilders = ImageBuilderListCopier.copyFromBuilder(imageBuilders);
        }

        @Override
        @Transient
        public final Builder imageBuilders(Collection<ImageBuilder> imageBuilders) {
            this.imageBuilders = ImageBuilderListCopier.copy(imageBuilders);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder imageBuilders(ImageBuilder ... imageBuilders) {
            this.imageBuilders(Arrays.asList(imageBuilders));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder imageBuilders(Consumer<ImageBuilder.Builder> ... imageBuilders) {
            this.imageBuilders(Stream.of(imageBuilders).map(c -> (ImageBuilder)((ImageBuilder.Builder)ImageBuilder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeImageBuildersResponse build() {
            return new DescribeImageBuildersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppStreamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImageBuildersResponse> {
        public Builder imageBuilders(Collection<ImageBuilder> var1);

        public Builder imageBuilders(ImageBuilder ... var1);

        public Builder imageBuilders(Consumer<ImageBuilder.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

