/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartImageBuilderRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, StartImageBuilderRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StartImageBuilderRequest.getter(StartImageBuilderRequest::name)).setter(StartImageBuilderRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> APPSTREAM_AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppstreamAgentVersion").getter(StartImageBuilderRequest.getter(StartImageBuilderRequest::appstreamAgentVersion)).setter(StartImageBuilderRequest.setter(Builder::appstreamAgentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppstreamAgentVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, APPSTREAM_AGENT_VERSION_FIELD));
    private final String name;
    private final String appstreamAgentVersion;

    private StartImageBuilderRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.appstreamAgentVersion = builder.appstreamAgentVersion;
    }

    public final String name() {
        return this.name;
    }

    public final String appstreamAgentVersion() {
        return this.appstreamAgentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.appstreamAgentVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImageBuilderRequest)) {
            return false;
        }
        StartImageBuilderRequest other = (StartImageBuilderRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.appstreamAgentVersion(), other.appstreamAgentVersion());
    }

    public final String toString() {
        return ToString.builder((String)"StartImageBuilderRequest").add("Name", (Object)this.name()).add("AppstreamAgentVersion", (Object)this.appstreamAgentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AppstreamAgentVersion": {
                return Optional.ofNullable(clazz.cast(this.appstreamAgentVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartImageBuilderRequest, T> g) {
        return obj -> g.apply((StartImageBuilderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String name;
        private String appstreamAgentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImageBuilderRequest model) {
            super(model);
            this.name(model.name);
            this.appstreamAgentVersion(model.appstreamAgentVersion);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAppstreamAgentVersion() {
            return this.appstreamAgentVersion;
        }

        public final void setAppstreamAgentVersion(String appstreamAgentVersion) {
            this.appstreamAgentVersion = appstreamAgentVersion;
        }

        @Override
        public final Builder appstreamAgentVersion(String appstreamAgentVersion) {
            this.appstreamAgentVersion = appstreamAgentVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImageBuilderRequest build() {
            return new StartImageBuilderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartImageBuilderRequest> {
        public Builder name(String var1);

        public Builder appstreamAgentVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

