/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppStreamResponse;
import software.amazon.awssdk.services.appstream.model.Image;
import software.amazon.awssdk.services.appstream.model.ImageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImagesResponse
extends AppStreamResponse
implements ToCopyableBuilder<Builder, DescribeImagesResponse> {
    private static final SdkField<List<Image>> IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Images").getter(DescribeImagesResponse.getter(DescribeImagesResponse::images)).setter(DescribeImagesResponse.setter(Builder::images)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Images").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Image::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeImagesResponse.getter(DescribeImagesResponse::nextToken)).setter(DescribeImagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGES_FIELD, NEXT_TOKEN_FIELD));
    private final List<Image> images;
    private final String nextToken;

    private DescribeImagesResponse(BuilderImpl builder) {
        super(builder);
        this.images = builder.images;
        this.nextToken = builder.nextToken;
    }

    public boolean hasImages() {
        return this.images != null && !(this.images instanceof SdkAutoConstructList);
    }

    public List<Image> images() {
        return this.images;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImages() ? this.images() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesResponse)) {
            return false;
        }
        DescribeImagesResponse other = (DescribeImagesResponse)((Object)obj);
        return this.hasImages() == other.hasImages() && Objects.equals(this.images(), other.images()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeImagesResponse").add("Images", this.hasImages() ? this.images() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Images": {
                return Optional.ofNullable(clazz.cast(this.images()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImagesResponse, T> g) {
        return obj -> g.apply((DescribeImagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamResponse.BuilderImpl
    implements Builder {
        private List<Image> images = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagesResponse model) {
            super(model);
            this.images(model.images);
            this.nextToken(model.nextToken);
        }

        public final Collection<Image.Builder> getImages() {
            if (this.images instanceof SdkAutoConstructList) {
                return null;
            }
            return this.images != null ? (Collection)this.images.stream().map(Image::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder images(Collection<Image> images) {
            this.images = ImageListCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Image ... images) {
            this.images(Arrays.asList(images));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Consumer<Image.Builder> ... images) {
            this.images(Stream.of(images).map(c -> (Image)((Image.Builder)Image.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImages(Collection<Image.BuilderImpl> images) {
            this.images = ImageListCopier.copyFromBuilder(images);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeImagesResponse build() {
            return new DescribeImagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppStreamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImagesResponse> {
        public Builder images(Collection<Image> var1);

        public Builder images(Image ... var1);

        public Builder images(Consumer<Image.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

