/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.OrganizationalUnitDistinguishedNamesListCopier;
import software.amazon.awssdk.services.appstream.model.ServiceAccountCredentials;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DirectoryConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DirectoryConfig> {
    private static final SdkField<String> DIRECTORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryName").getter(DirectoryConfig.getter(DirectoryConfig::directoryName)).setter(DirectoryConfig.setter(Builder::directoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryName").build()}).build();
    private static final SdkField<List<String>> ORGANIZATIONAL_UNIT_DISTINGUISHED_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationalUnitDistinguishedNames").getter(DirectoryConfig.getter(DirectoryConfig::organizationalUnitDistinguishedNames)).setter(DirectoryConfig.setter(Builder::organizationalUnitDistinguishedNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitDistinguishedNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ServiceAccountCredentials> SERVICE_ACCOUNT_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceAccountCredentials").getter(DirectoryConfig.getter(DirectoryConfig::serviceAccountCredentials)).setter(DirectoryConfig.setter(Builder::serviceAccountCredentials)).constructor(ServiceAccountCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccountCredentials").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DirectoryConfig.getter(DirectoryConfig::createdTime)).setter(DirectoryConfig.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_NAME_FIELD, ORGANIZATIONAL_UNIT_DISTINGUISHED_NAMES_FIELD, SERVICE_ACCOUNT_CREDENTIALS_FIELD, CREATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String directoryName;
    private final List<String> organizationalUnitDistinguishedNames;
    private final ServiceAccountCredentials serviceAccountCredentials;
    private final Instant createdTime;

    private DirectoryConfig(BuilderImpl builder) {
        this.directoryName = builder.directoryName;
        this.organizationalUnitDistinguishedNames = builder.organizationalUnitDistinguishedNames;
        this.serviceAccountCredentials = builder.serviceAccountCredentials;
        this.createdTime = builder.createdTime;
    }

    public String directoryName() {
        return this.directoryName;
    }

    public boolean hasOrganizationalUnitDistinguishedNames() {
        return this.organizationalUnitDistinguishedNames != null && !(this.organizationalUnitDistinguishedNames instanceof SdkAutoConstructList);
    }

    public List<String> organizationalUnitDistinguishedNames() {
        return this.organizationalUnitDistinguishedNames;
    }

    public ServiceAccountCredentials serviceAccountCredentials() {
        return this.serviceAccountCredentials;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationalUnitDistinguishedNames() ? this.organizationalUnitDistinguishedNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccountCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectoryConfig)) {
            return false;
        }
        DirectoryConfig other = (DirectoryConfig)obj;
        return Objects.equals(this.directoryName(), other.directoryName()) && this.hasOrganizationalUnitDistinguishedNames() == other.hasOrganizationalUnitDistinguishedNames() && Objects.equals(this.organizationalUnitDistinguishedNames(), other.organizationalUnitDistinguishedNames()) && Objects.equals(this.serviceAccountCredentials(), other.serviceAccountCredentials()) && Objects.equals(this.createdTime(), other.createdTime());
    }

    public String toString() {
        return ToString.builder((String)"DirectoryConfig").add("DirectoryName", (Object)this.directoryName()).add("OrganizationalUnitDistinguishedNames", this.hasOrganizationalUnitDistinguishedNames() ? this.organizationalUnitDistinguishedNames() : null).add("ServiceAccountCredentials", (Object)this.serviceAccountCredentials()).add("CreatedTime", (Object)this.createdTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryName": {
                return Optional.ofNullable(clazz.cast(this.directoryName()));
            }
            case "OrganizationalUnitDistinguishedNames": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitDistinguishedNames()));
            }
            case "ServiceAccountCredentials": {
                return Optional.ofNullable(clazz.cast(this.serviceAccountCredentials()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DirectoryConfig, T> g) {
        return obj -> g.apply((DirectoryConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String directoryName;
        private List<String> organizationalUnitDistinguishedNames = DefaultSdkAutoConstructList.getInstance();
        private ServiceAccountCredentials serviceAccountCredentials;
        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectoryConfig model) {
            this.directoryName(model.directoryName);
            this.organizationalUnitDistinguishedNames(model.organizationalUnitDistinguishedNames);
            this.serviceAccountCredentials(model.serviceAccountCredentials);
            this.createdTime(model.createdTime);
        }

        public final String getDirectoryName() {
            return this.directoryName;
        }

        @Override
        public final Builder directoryName(String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        public final void setDirectoryName(String directoryName) {
            this.directoryName = directoryName;
        }

        public final Collection<String> getOrganizationalUnitDistinguishedNames() {
            if (this.organizationalUnitDistinguishedNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationalUnitDistinguishedNames;
        }

        @Override
        public final Builder organizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames) {
            this.organizationalUnitDistinguishedNames = OrganizationalUnitDistinguishedNamesListCopier.copy(organizationalUnitDistinguishedNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitDistinguishedNames(String ... organizationalUnitDistinguishedNames) {
            this.organizationalUnitDistinguishedNames(Arrays.asList(organizationalUnitDistinguishedNames));
            return this;
        }

        public final void setOrganizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames) {
            this.organizationalUnitDistinguishedNames = OrganizationalUnitDistinguishedNamesListCopier.copy(organizationalUnitDistinguishedNames);
        }

        public final ServiceAccountCredentials.Builder getServiceAccountCredentials() {
            return this.serviceAccountCredentials != null ? this.serviceAccountCredentials.toBuilder() : null;
        }

        @Override
        public final Builder serviceAccountCredentials(ServiceAccountCredentials serviceAccountCredentials) {
            this.serviceAccountCredentials = serviceAccountCredentials;
            return this;
        }

        public final void setServiceAccountCredentials(ServiceAccountCredentials.BuilderImpl serviceAccountCredentials) {
            this.serviceAccountCredentials = serviceAccountCredentials != null ? serviceAccountCredentials.build() : null;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public DirectoryConfig build() {
            return new DirectoryConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DirectoryConfig> {
        public Builder directoryName(String var1);

        public Builder organizationalUnitDistinguishedNames(Collection<String> var1);

        public Builder organizationalUnitDistinguishedNames(String ... var1);

        public Builder serviceAccountCredentials(ServiceAccountCredentials var1);

        default public Builder serviceAccountCredentials(Consumer<ServiceAccountCredentials.Builder> serviceAccountCredentials) {
            return this.serviceAccountCredentials((ServiceAccountCredentials)((ServiceAccountCredentials.Builder)ServiceAccountCredentials.builder().applyMutation(serviceAccountCredentials)).build());
        }

        public Builder createdTime(Instant var1);
    }
}

