/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.ImagePermissions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateImagePermissionsRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, UpdateImagePermissionsRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateImagePermissionsRequest.getter(UpdateImagePermissionsRequest::name)).setter(UpdateImagePermissionsRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SHARED_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SharedAccountId").getter(UpdateImagePermissionsRequest.getter(UpdateImagePermissionsRequest::sharedAccountId)).setter(UpdateImagePermissionsRequest.setter(Builder::sharedAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedAccountId").build()}).build();
    private static final SdkField<ImagePermissions> IMAGE_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImagePermissions").getter(UpdateImagePermissionsRequest.getter(UpdateImagePermissionsRequest::imagePermissions)).setter(UpdateImagePermissionsRequest.setter(Builder::imagePermissions)).constructor(ImagePermissions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImagePermissions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SHARED_ACCOUNT_ID_FIELD, IMAGE_PERMISSIONS_FIELD));
    private final String name;
    private final String sharedAccountId;
    private final ImagePermissions imagePermissions;

    private UpdateImagePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.sharedAccountId = builder.sharedAccountId;
        this.imagePermissions = builder.imagePermissions;
    }

    public String name() {
        return this.name;
    }

    public String sharedAccountId() {
        return this.sharedAccountId;
    }

    public ImagePermissions imagePermissions() {
        return this.imagePermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePermissions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateImagePermissionsRequest)) {
            return false;
        }
        UpdateImagePermissionsRequest other = (UpdateImagePermissionsRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.sharedAccountId(), other.sharedAccountId()) && Objects.equals(this.imagePermissions(), other.imagePermissions());
    }

    public String toString() {
        return ToString.builder((String)"UpdateImagePermissionsRequest").add("Name", (Object)this.name()).add("SharedAccountId", (Object)this.sharedAccountId()).add("ImagePermissions", (Object)this.imagePermissions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SharedAccountId": {
                return Optional.ofNullable(clazz.cast(this.sharedAccountId()));
            }
            case "ImagePermissions": {
                return Optional.ofNullable(clazz.cast(this.imagePermissions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateImagePermissionsRequest, T> g) {
        return obj -> g.apply((UpdateImagePermissionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String name;
        private String sharedAccountId;
        private ImagePermissions imagePermissions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateImagePermissionsRequest model) {
            super(model);
            this.name(model.name);
            this.sharedAccountId(model.sharedAccountId);
            this.imagePermissions(model.imagePermissions);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSharedAccountId() {
            return this.sharedAccountId;
        }

        @Override
        public final Builder sharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
            return this;
        }

        public final void setSharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
        }

        public final ImagePermissions.Builder getImagePermissions() {
            return this.imagePermissions != null ? this.imagePermissions.toBuilder() : null;
        }

        @Override
        public final Builder imagePermissions(ImagePermissions imagePermissions) {
            this.imagePermissions = imagePermissions;
            return this;
        }

        public final void setImagePermissions(ImagePermissions.BuilderImpl imagePermissions) {
            this.imagePermissions = imagePermissions != null ? imagePermissions.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateImagePermissionsRequest build() {
            return new UpdateImagePermissionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateImagePermissionsRequest> {
        public Builder name(String var1);

        public Builder sharedAccountId(String var1);

        public Builder imagePermissions(ImagePermissions var1);

        default public Builder imagePermissions(Consumer<ImagePermissions.Builder> imagePermissions) {
            return this.imagePermissions((ImagePermissions)((ImagePermissions.Builder)ImagePermissions.builder().applyMutation(imagePermissions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

