/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appstream.model.AccessEndpointType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessEndpoint> {
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AccessEndpoint.getter(AccessEndpoint::endpointTypeAsString)).setter(AccessEndpoint.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<String> VPCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AccessEndpoint.getter(AccessEndpoint::vpceId)).setter(AccessEndpoint.setter(Builder::vpceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_TYPE_FIELD, VPCE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String endpointType;
    private final String vpceId;

    private AccessEndpoint(BuilderImpl builder) {
        this.endpointType = builder.endpointType;
        this.vpceId = builder.vpceId;
    }

    public AccessEndpointType endpointType() {
        return AccessEndpointType.fromValue(this.endpointType);
    }

    public String endpointTypeAsString() {
        return this.endpointType;
    }

    public String vpceId() {
        return this.vpceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessEndpoint)) {
            return false;
        }
        AccessEndpoint other = (AccessEndpoint)obj;
        return Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(this.vpceId(), other.vpceId());
    }

    public String toString() {
        return ToString.builder((String)"AccessEndpoint").add("EndpointType", (Object)this.endpointTypeAsString()).add("VpceId", (Object)this.vpceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
            case "VpceId": {
                return Optional.ofNullable(clazz.cast(this.vpceId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessEndpoint, T> g) {
        return obj -> g.apply((AccessEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointType;
        private String vpceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessEndpoint model) {
            this.endpointType(model.endpointType);
            this.vpceId(model.vpceId);
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(AccessEndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        public final String getVpceId() {
            return this.vpceId;
        }

        @Override
        public final Builder vpceId(String vpceId) {
            this.vpceId = vpceId;
            return this;
        }

        public final void setVpceId(String vpceId) {
            this.vpceId = vpceId;
        }

        public AccessEndpoint build() {
            return new AccessEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessEndpoint> {
        public Builder endpointType(String var1);

        public Builder endpointType(AccessEndpointType var1);

        public Builder vpceId(String var1);
    }
}

