/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appstream.AppStreamAsyncClient;
import software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsResponse;

public class DescribeImagePermissionsPublisher
implements SdkPublisher<DescribeImagePermissionsResponse> {
    private final AppStreamAsyncClient client;
    private final DescribeImagePermissionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeImagePermissionsPublisher(AppStreamAsyncClient client, DescribeImagePermissionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeImagePermissionsPublisher(AppStreamAsyncClient client, DescribeImagePermissionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeImagePermissionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeImagePermissionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final DescribeImagePermissionsPublisher resume(DescribeImagePermissionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeImagePermissionsPublisher(this.client, (DescribeImagePermissionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeImagePermissionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeImagePermissionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeImagePermissionsResponseFetcher
    implements AsyncPageFetcher<DescribeImagePermissionsResponse> {
        private DescribeImagePermissionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImagePermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeImagePermissionsResponse> nextPage(DescribeImagePermissionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeImagePermissionsPublisher.this.client.describeImagePermissions(DescribeImagePermissionsPublisher.this.firstRequest);
            }
            return DescribeImagePermissionsPublisher.this.client.describeImagePermissions((DescribeImagePermissionsRequest)((Object)DescribeImagePermissionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

