/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.Session;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SessionMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> USERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserId").isBinary(false).build();
    private static final MarshallingInfo<String> STACKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackName").isBinary(false).build();
    private static final MarshallingInfo<String> FLEETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FleetName").isBinary(false).build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHENTICATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AuthenticationType").isBinary(false).build();
    private static final SessionMarshaller INSTANCE = new SessionMarshaller();

    private SessionMarshaller() {
    }

    public static SessionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Session session, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)session, (String)"session");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)session.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)session.userId(), USERID_BINDING);
            protocolMarshaller.marshall((Object)session.stackName(), STACKNAME_BINDING);
            protocolMarshaller.marshall((Object)session.fleetName(), FLEETNAME_BINDING);
            protocolMarshaller.marshall((Object)session.stateString(), STATE_BINDING);
            protocolMarshaller.marshall((Object)session.authenticationTypeString(), AUTHENTICATIONTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

