/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.DirectoryConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DirectoryConfigMarshaller {
    private static final MarshallingInfo<String> DIRECTORYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DirectoryName").isBinary(false).build();
    private static final MarshallingInfo<List> ORGANIZATIONALUNITDISTINGUISHEDNAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrganizationalUnitDistinguishedNames").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SERVICEACCOUNTCREDENTIALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceAccountCredentials").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").isBinary(false).build();
    private static final DirectoryConfigMarshaller INSTANCE = new DirectoryConfigMarshaller();

    private DirectoryConfigMarshaller() {
    }

    public static DirectoryConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DirectoryConfig directoryConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)directoryConfig, (String)"directoryConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)directoryConfig.directoryName(), DIRECTORYNAME_BINDING);
            protocolMarshaller.marshall(directoryConfig.organizationalUnitDistinguishedNames(), ORGANIZATIONALUNITDISTINGUISHEDNAMES_BINDING);
            protocolMarshaller.marshall((Object)directoryConfig.serviceAccountCredentials(), SERVICEACCOUNTCREDENTIALS_BINDING);
            protocolMarshaller.marshall((Object)directoryConfig.createdTime(), CREATEDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

