/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.Application;
import software.amazon.awssdk.services.appstream.model.ApplicationsCopier;
import software.amazon.awssdk.services.appstream.model.ImageState;
import software.amazon.awssdk.services.appstream.model.ImageStateChangeReason;
import software.amazon.awssdk.services.appstream.model.PlatformType;
import software.amazon.awssdk.services.appstream.model.VisibilityType;
import software.amazon.awssdk.services.appstream.transform.ImageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Image
implements StructuredPojo,
ToCopyableBuilder<Builder, Image> {
    private final String name;
    private final String arn;
    private final String baseImageArn;
    private final String displayName;
    private final String state;
    private final String visibility;
    private final Boolean imageBuilderSupported;
    private final String platform;
    private final String description;
    private final ImageStateChangeReason stateChangeReason;
    private final List<Application> applications;
    private final Instant createdTime;
    private final Instant publicBaseImageReleasedDate;

    private Image(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.baseImageArn = builder.baseImageArn;
        this.displayName = builder.displayName;
        this.state = builder.state;
        this.visibility = builder.visibility;
        this.imageBuilderSupported = builder.imageBuilderSupported;
        this.platform = builder.platform;
        this.description = builder.description;
        this.stateChangeReason = builder.stateChangeReason;
        this.applications = builder.applications;
        this.createdTime = builder.createdTime;
        this.publicBaseImageReleasedDate = builder.publicBaseImageReleasedDate;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String baseImageArn() {
        return this.baseImageArn;
    }

    public String displayName() {
        return this.displayName;
    }

    public String state() {
        return this.state;
    }

    public String visibility() {
        return this.visibility;
    }

    public Boolean imageBuilderSupported() {
        return this.imageBuilderSupported;
    }

    public String platform() {
        return this.platform;
    }

    public String description() {
        return this.description;
    }

    public ImageStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public List<Application> applications() {
        return this.applications;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Instant publicBaseImageReleasedDate() {
        return this.publicBaseImageReleasedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.baseImageArn() == null ? 0 : this.baseImageArn().hashCode());
        hashCode = 31 * hashCode + (this.displayName() == null ? 0 : this.displayName().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.visibility() == null ? 0 : this.visibility().hashCode());
        hashCode = 31 * hashCode + (this.imageBuilderSupported() == null ? 0 : this.imageBuilderSupported().hashCode());
        hashCode = 31 * hashCode + (this.platform() == null ? 0 : this.platform().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.stateChangeReason() == null ? 0 : this.stateChangeReason().hashCode());
        hashCode = 31 * hashCode + (this.applications() == null ? 0 : this.applications().hashCode());
        hashCode = 31 * hashCode + (this.createdTime() == null ? 0 : this.createdTime().hashCode());
        hashCode = 31 * hashCode + (this.publicBaseImageReleasedDate() == null ? 0 : this.publicBaseImageReleasedDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.baseImageArn() == null ^ this.baseImageArn() == null) {
            return false;
        }
        if (other.baseImageArn() != null && !other.baseImageArn().equals(this.baseImageArn())) {
            return false;
        }
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.visibility() == null ^ this.visibility() == null) {
            return false;
        }
        if (other.visibility() != null && !other.visibility().equals(this.visibility())) {
            return false;
        }
        if (other.imageBuilderSupported() == null ^ this.imageBuilderSupported() == null) {
            return false;
        }
        if (other.imageBuilderSupported() != null && !other.imageBuilderSupported().equals(this.imageBuilderSupported())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.stateChangeReason() == null ^ this.stateChangeReason() == null) {
            return false;
        }
        if (other.stateChangeReason() != null && !other.stateChangeReason().equals(this.stateChangeReason())) {
            return false;
        }
        if (other.applications() == null ^ this.applications() == null) {
            return false;
        }
        if (other.applications() != null && !other.applications().equals(this.applications())) {
            return false;
        }
        if (other.createdTime() == null ^ this.createdTime() == null) {
            return false;
        }
        if (other.createdTime() != null && !other.createdTime().equals(this.createdTime())) {
            return false;
        }
        if (other.publicBaseImageReleasedDate() == null ^ this.publicBaseImageReleasedDate() == null) {
            return false;
        }
        return other.publicBaseImageReleasedDate() == null || other.publicBaseImageReleasedDate().equals(this.publicBaseImageReleasedDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.baseImageArn() != null) {
            sb.append("BaseImageArn: ").append(this.baseImageArn()).append(",");
        }
        if (this.displayName() != null) {
            sb.append("DisplayName: ").append(this.displayName()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.visibility() != null) {
            sb.append("Visibility: ").append(this.visibility()).append(",");
        }
        if (this.imageBuilderSupported() != null) {
            sb.append("ImageBuilderSupported: ").append(this.imageBuilderSupported()).append(",");
        }
        if (this.platform() != null) {
            sb.append("Platform: ").append(this.platform()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.stateChangeReason() != null) {
            sb.append("StateChangeReason: ").append(this.stateChangeReason()).append(",");
        }
        if (this.applications() != null) {
            sb.append("Applications: ").append(this.applications()).append(",");
        }
        if (this.createdTime() != null) {
            sb.append("CreatedTime: ").append(this.createdTime()).append(",");
        }
        if (this.publicBaseImageReleasedDate() != null) {
            sb.append("PublicBaseImageReleasedDate: ").append(this.publicBaseImageReleasedDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String baseImageArn;
        private String displayName;
        private String state;
        private String visibility;
        private Boolean imageBuilderSupported;
        private String platform;
        private String description;
        private ImageStateChangeReason stateChangeReason;
        private List<Application> applications;
        private Instant createdTime;
        private Instant publicBaseImageReleasedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            this.setName(model.name);
            this.setArn(model.arn);
            this.setBaseImageArn(model.baseImageArn);
            this.setDisplayName(model.displayName);
            this.setState(model.state);
            this.setVisibility(model.visibility);
            this.setImageBuilderSupported(model.imageBuilderSupported);
            this.setPlatform(model.platform);
            this.setDescription(model.description);
            this.setStateChangeReason(model.stateChangeReason);
            this.setApplications(model.applications);
            this.setCreatedTime(model.createdTime);
            this.setPublicBaseImageReleasedDate(model.publicBaseImageReleasedDate);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getBaseImageArn() {
            return this.baseImageArn;
        }

        @Override
        public final Builder baseImageArn(String baseImageArn) {
            this.baseImageArn = baseImageArn;
            return this;
        }

        public final void setBaseImageArn(String baseImageArn) {
            this.baseImageArn = baseImageArn;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ImageState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(VisibilityType visibility) {
            this.visibility(visibility.toString());
            return this;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        public final Boolean getImageBuilderSupported() {
            return this.imageBuilderSupported;
        }

        @Override
        public final Builder imageBuilderSupported(Boolean imageBuilderSupported) {
            this.imageBuilderSupported = imageBuilderSupported;
            return this;
        }

        public final void setImageBuilderSupported(Boolean imageBuilderSupported) {
            this.imageBuilderSupported = imageBuilderSupported;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformType platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ImageStateChangeReason getStateChangeReason() {
            return this.stateChangeReason;
        }

        @Override
        public final Builder stateChangeReason(ImageStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(ImageStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
        }

        public final Collection<Application> getApplications() {
            return this.applications;
        }

        @Override
        public final Builder applications(Collection<Application> applications) {
            this.applications = ApplicationsCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Application ... applications) {
            this.applications(Arrays.asList(applications));
            return this;
        }

        public final void setApplications(Collection<Application> applications) {
            this.applications = ApplicationsCopier.copy(applications);
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getPublicBaseImageReleasedDate() {
            return this.publicBaseImageReleasedDate;
        }

        @Override
        public final Builder publicBaseImageReleasedDate(Instant publicBaseImageReleasedDate) {
            this.publicBaseImageReleasedDate = publicBaseImageReleasedDate;
            return this;
        }

        public final void setPublicBaseImageReleasedDate(Instant publicBaseImageReleasedDate) {
            this.publicBaseImageReleasedDate = publicBaseImageReleasedDate;
        }

        public Image build() {
            return new Image(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Image> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder baseImageArn(String var1);

        public Builder displayName(String var1);

        public Builder state(String var1);

        public Builder state(ImageState var1);

        public Builder visibility(String var1);

        public Builder visibility(VisibilityType var1);

        public Builder imageBuilderSupported(Boolean var1);

        public Builder platform(String var1);

        public Builder platform(PlatformType var1);

        public Builder description(String var1);

        public Builder stateChangeReason(ImageStateChangeReason var1);

        public Builder applications(Collection<Application> var1);

        public Builder applications(Application ... var1);

        public Builder createdTime(Instant var1);

        public Builder publicBaseImageReleasedDate(Instant var1);
    }
}

