/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.services.appstream.model.SubnetIdListCopier;
import software.amazon.awssdk.services.appstream.transform.VpcConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VpcConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, VpcConfig> {
    private final List<String> subnetIds;
    private final List<String> securityGroupIds;

    private VpcConfig(BuilderImpl builder) {
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subnetIds() == null ? 0 : this.subnetIds().hashCode());
        hashCode = 31 * hashCode + (this.securityGroupIds() == null ? 0 : this.securityGroupIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConfig)) {
            return false;
        }
        VpcConfig other = (VpcConfig)obj;
        if (other.subnetIds() == null ^ this.subnetIds() == null) {
            return false;
        }
        if (other.subnetIds() != null && !other.subnetIds().equals(this.subnetIds())) {
            return false;
        }
        if (other.securityGroupIds() == null ^ this.securityGroupIds() == null) {
            return false;
        }
        return other.securityGroupIds() == null || other.securityGroupIds().equals(this.securityGroupIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subnetIds() != null) {
            sb.append("SubnetIds: ").append(this.subnetIds()).append(",");
        }
        if (this.securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.securityGroupIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VpcConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> subnetIds;
        private List<String> securityGroupIds;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConfig model) {
            this.setSubnetIds(model.subnetIds);
            this.setSecurityGroupIds(model.securityGroupIds);
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        @SafeVarargs
        public final void setSubnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @SafeVarargs
        public final void setSecurityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
        }

        public VpcConfig build() {
            return new VpcConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpcConfig> {
        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);
    }
}

