/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.appstream.model.Image;
import software.amazon.awssdk.services.appstream.model.ImageListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeImagesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeImagesResponse> {
    private final List<Image> images;

    private DescribeImagesResponse(BuilderImpl builder) {
        this.images = builder.images;
    }

    public List<Image> images() {
        return this.images;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.images() == null ? 0 : this.images().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesResponse)) {
            return false;
        }
        DescribeImagesResponse other = (DescribeImagesResponse)((Object)obj);
        if (other.images() == null ^ this.images() == null) {
            return false;
        }
        return other.images() == null || other.images().equals(this.images());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.images() != null) {
            sb.append("Images: ").append(this.images()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Image> images;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagesResponse model) {
            this.setImages(model.images);
        }

        public final Collection<Image> getImages() {
            return this.images;
        }

        @Override
        public final Builder images(Collection<Image> images) {
            this.images = ImageListCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Image ... images) {
            this.images(Arrays.asList(images));
            return this;
        }

        public final void setImages(Collection<Image> images) {
            this.images = ImageListCopier.copy(images);
        }

        @SafeVarargs
        public final void setImages(Image ... images) {
            this.images(Arrays.asList(images));
        }

        public DescribeImagesResponse build() {
            return new DescribeImagesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeImagesResponse> {
        public Builder images(Collection<Image> var1);

        public Builder images(Image ... var1);
    }
}

