/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.appstream.model.Fleet;
import software.amazon.awssdk.services.appstream.model.FleetListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFleetsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeFleetsResponse> {
    private final List<Fleet> fleets;
    private final String nextToken;

    private DescribeFleetsResponse(BuilderImpl builder) {
        this.fleets = builder.fleets;
        this.nextToken = builder.nextToken;
    }

    public List<Fleet> fleets() {
        return this.fleets;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.fleets() == null ? 0 : this.fleets().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetsResponse)) {
            return false;
        }
        DescribeFleetsResponse other = (DescribeFleetsResponse)((Object)obj);
        if (other.fleets() == null ^ this.fleets() == null) {
            return false;
        }
        if (other.fleets() != null && !other.fleets().equals(this.fleets())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fleets() != null) {
            sb.append("Fleets: ").append(this.fleets()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Fleet> fleets;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetsResponse model) {
            this.setFleets(model.fleets);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Fleet> getFleets() {
            return this.fleets;
        }

        @Override
        public final Builder fleets(Collection<Fleet> fleets) {
            this.fleets = FleetListCopier.copy(fleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleets(Fleet ... fleets) {
            this.fleets(Arrays.asList(fleets));
            return this;
        }

        public final void setFleets(Collection<Fleet> fleets) {
            this.fleets = FleetListCopier.copy(fleets);
        }

        @SafeVarargs
        public final void setFleets(Fleet ... fleets) {
            this.fleets(Arrays.asList(fleets));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeFleetsResponse build() {
            return new DescribeFleetsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeFleetsResponse> {
        public Builder fleets(Collection<Fleet> var1);

        public Builder fleets(Fleet ... var1);

        public Builder nextToken(String var1);
    }
}

