/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.StorageConnector;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StorageConnectorMarshaller {
    private static final MarshallingInfo<String> CONNECTORTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectorType").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceIdentifier").isBinary(false).build();
    private static final MarshallingInfo<List> DOMAINS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Domains").isBinary(false).build();
    private static final StorageConnectorMarshaller INSTANCE = new StorageConnectorMarshaller();

    private StorageConnectorMarshaller() {
    }

    public static StorageConnectorMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StorageConnector storageConnector, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)storageConnector, (String)"storageConnector");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)storageConnector.connectorTypeAsString(), CONNECTORTYPE_BINDING);
            protocolMarshaller.marshall((Object)storageConnector.resourceIdentifier(), RESOURCEIDENTIFIER_BINDING);
            protocolMarshaller.marshall(storageConnector.domains(), DOMAINS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

