/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.Stack;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StackMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisplayName").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").isBinary(false).build();
    private static final MarshallingInfo<List> STORAGECONNECTORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageConnectors").isBinary(false).build();
    private static final MarshallingInfo<String> REDIRECTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RedirectURL").isBinary(false).build();
    private static final MarshallingInfo<String> FEEDBACKURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FeedbackURL").isBinary(false).build();
    private static final MarshallingInfo<List> STACKERRORS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StackErrors").isBinary(false).build();
    private static final MarshallingInfo<List> USERSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> APPLICATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationSettings").isBinary(false).build();
    private static final StackMarshaller INSTANCE = new StackMarshaller();

    private StackMarshaller() {
    }

    public static StackMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Stack stack, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)stack, (String)"stack");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)stack.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)stack.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)stack.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)stack.displayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall((Object)stack.createdTime(), CREATEDTIME_BINDING);
            protocolMarshaller.marshall(stack.storageConnectors(), STORAGECONNECTORS_BINDING);
            protocolMarshaller.marshall((Object)stack.redirectURL(), REDIRECTURL_BINDING);
            protocolMarshaller.marshall((Object)stack.feedbackURL(), FEEDBACKURL_BINDING);
            protocolMarshaller.marshall(stack.stackErrors(), STACKERRORS_BINDING);
            protocolMarshaller.marshall(stack.userSettings(), USERSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)stack.applicationSettings(), APPLICATIONSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

