/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.appstream.model.ImagePermissions;

public class ImagePermissionsUnmarshaller
implements Unmarshaller<ImagePermissions, JsonUnmarshallerContext> {
    private static final ImagePermissionsUnmarshaller INSTANCE = new ImagePermissionsUnmarshaller();

    public ImagePermissions unmarshall(JsonUnmarshallerContext context) throws Exception {
        ImagePermissions.Builder imagePermissionsBuilder = ImagePermissions.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("allowFleet", targetDepth)) {
                    context.nextToken();
                    imagePermissionsBuilder.allowFleet((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("allowImageBuilder", targetDepth)) {
                    context.nextToken();
                    imagePermissionsBuilder.allowImageBuilder((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ImagePermissions)imagePermissionsBuilder.build();
    }

    public static ImagePermissionsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

