/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.Action;
import software.amazon.awssdk.services.appstream.model.Permission;
import software.amazon.awssdk.services.appstream.transform.UserSettingMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserSetting
implements StructuredPojo,
ToCopyableBuilder<Builder, UserSetting> {
    private final String action;
    private final String permission;

    private UserSetting(BuilderImpl builder) {
        this.action = builder.action;
        this.permission = builder.permission;
    }

    public Action action() {
        return Action.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public Permission permission() {
        return Permission.fromValue(this.permission);
    }

    public String permissionAsString() {
        return this.permission;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSetting)) {
            return false;
        }
        UserSetting other = (UserSetting)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.permissionAsString(), other.permissionAsString());
    }

    public String toString() {
        return ToString.builder((String)"UserSetting").add("Action", (Object)this.actionAsString()).add("Permission", (Object)this.permissionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Permission": {
                return Optional.ofNullable(clazz.cast(this.permissionAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserSettingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private String permission;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSetting model) {
            this.action(model.action);
            this.permission(model.permission);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getPermission() {
            return this.permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(Permission permission) {
            this.permission(permission.toString());
            return this;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        public UserSetting build() {
            return new UserSetting(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UserSetting> {
        public Builder action(String var1);

        public Builder action(Action var1);

        public Builder permission(String var1);

        public Builder permission(Permission var1);
    }
}

