/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartImageBuilderRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, StartImageBuilderRequest> {
    private final String name;
    private final String appstreamAgentVersion;

    private StartImageBuilderRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.appstreamAgentVersion = builder.appstreamAgentVersion;
    }

    public String name() {
        return this.name;
    }

    public String appstreamAgentVersion() {
        return this.appstreamAgentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.appstreamAgentVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImageBuilderRequest)) {
            return false;
        }
        StartImageBuilderRequest other = (StartImageBuilderRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.appstreamAgentVersion(), other.appstreamAgentVersion());
    }

    public String toString() {
        return ToString.builder((String)"StartImageBuilderRequest").add("Name", (Object)this.name()).add("AppstreamAgentVersion", (Object)this.appstreamAgentVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AppstreamAgentVersion": {
                return Optional.ofNullable(clazz.cast(this.appstreamAgentVersion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String name;
        private String appstreamAgentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImageBuilderRequest model) {
            super(model);
            this.name(model.name);
            this.appstreamAgentVersion(model.appstreamAgentVersion);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getAppstreamAgentVersion() {
            return this.appstreamAgentVersion;
        }

        @Override
        public final Builder appstreamAgentVersion(String appstreamAgentVersion) {
            this.appstreamAgentVersion = appstreamAgentVersion;
            return this;
        }

        public final void setAppstreamAgentVersion(String appstreamAgentVersion) {
            this.appstreamAgentVersion = appstreamAgentVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImageBuilderRequest build() {
            return new StartImageBuilderRequest(this);
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    CopyableBuilder<Builder, StartImageBuilderRequest> {
        public Builder name(String var1);

        public Builder appstreamAgentVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

