/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.transform.NetworkAccessConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkAccessConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, NetworkAccessConfiguration> {
    private final String eniPrivateIpAddress;
    private final String eniId;

    private NetworkAccessConfiguration(BuilderImpl builder) {
        this.eniPrivateIpAddress = builder.eniPrivateIpAddress;
        this.eniId = builder.eniId;
    }

    public String eniPrivateIpAddress() {
        return this.eniPrivateIpAddress;
    }

    public String eniId() {
        return this.eniId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eniPrivateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.eniId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAccessConfiguration)) {
            return false;
        }
        NetworkAccessConfiguration other = (NetworkAccessConfiguration)obj;
        return Objects.equals(this.eniPrivateIpAddress(), other.eniPrivateIpAddress()) && Objects.equals(this.eniId(), other.eniId());
    }

    public String toString() {
        return ToString.builder((String)"NetworkAccessConfiguration").add("EniPrivateIpAddress", (Object)this.eniPrivateIpAddress()).add("EniId", (Object)this.eniId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EniPrivateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.eniPrivateIpAddress()));
            }
            case "EniId": {
                return Optional.ofNullable(clazz.cast(this.eniId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NetworkAccessConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String eniPrivateIpAddress;
        private String eniId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkAccessConfiguration model) {
            this.eniPrivateIpAddress(model.eniPrivateIpAddress);
            this.eniId(model.eniId);
        }

        public final String getEniPrivateIpAddress() {
            return this.eniPrivateIpAddress;
        }

        @Override
        public final Builder eniPrivateIpAddress(String eniPrivateIpAddress) {
            this.eniPrivateIpAddress = eniPrivateIpAddress;
            return this;
        }

        public final void setEniPrivateIpAddress(String eniPrivateIpAddress) {
            this.eniPrivateIpAddress = eniPrivateIpAddress;
        }

        public final String getEniId() {
            return this.eniId;
        }

        @Override
        public final Builder eniId(String eniId) {
            this.eniId = eniId;
            return this;
        }

        public final void setEniId(String eniId) {
            this.eniId = eniId;
        }

        public NetworkAccessConfiguration build() {
            return new NetworkAccessConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NetworkAccessConfiguration> {
        public Builder eniPrivateIpAddress(String var1);

        public Builder eniId(String var1);
    }
}

