/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.appstream.model.ImageStateChangeReasonCode;
import software.amazon.awssdk.services.appstream.transform.ImageStateChangeReasonMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageStateChangeReason
implements StructuredPojo,
ToCopyableBuilder<Builder, ImageStateChangeReason> {
    private final String code;
    private final String message;

    private ImageStateChangeReason(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
    }

    public ImageStateChangeReasonCode code() {
        return ImageStateChangeReasonCode.fromValue(this.code);
    }

    public String codeAsString() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageStateChangeReason)) {
            return false;
        }
        ImageStateChangeReason other = (ImageStateChangeReason)obj;
        return Objects.equals(this.codeAsString(), other.codeAsString()) && Objects.equals(this.message(), other.message());
    }

    public String toString() {
        return ToString.builder((String)"ImageStateChangeReason").add("Code", (Object)this.codeAsString()).add("Message", (Object)this.message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.codeAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageStateChangeReasonMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String code;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageStateChangeReason model) {
            this.code(model.code);
            this.message(model.message);
        }

        public final String getCode() {
            return this.code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(ImageStateChangeReasonCode code) {
            this.code(code.toString());
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public ImageStateChangeReason build() {
            return new ImageStateChangeReason(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImageStateChangeReason> {
        public Builder code(String var1);

        public Builder code(ImageStateChangeReasonCode var1);

        public Builder message(String var1);
    }
}

