/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.appstream.model.ComputeCapacity;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ComputeCapacityMarshaller {
    private static final MarshallingInfo<Integer> DESIREDINSTANCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DesiredInstances").isBinary(false).build();
    private static final ComputeCapacityMarshaller INSTANCE = new ComputeCapacityMarshaller();

    private ComputeCapacityMarshaller() {
    }

    public static ComputeCapacityMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ComputeCapacity computeCapacity, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)computeCapacity, (String)"computeCapacity");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)computeCapacity.desiredInstances(), DESIREDINSTANCES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

