/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.DomainJoinInfo;
import software.amazon.awssdk.services.appstream.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateImageBuilderRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, CreateImageBuilderRequest> {
    private final String name;
    private final String imageName;
    private final String instanceType;
    private final String description;
    private final String displayName;
    private final VpcConfig vpcConfig;
    private final Boolean enableDefaultInternetAccess;
    private final DomainJoinInfo domainJoinInfo;

    private CreateImageBuilderRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.imageName = builder.imageName;
        this.instanceType = builder.instanceType;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.vpcConfig = builder.vpcConfig;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
        this.domainJoinInfo = builder.domainJoinInfo;
    }

    public String name() {
        return this.name;
    }

    public String imageName() {
        return this.imageName;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String description() {
        return this.description;
    }

    public String displayName() {
        return this.displayName;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public Boolean enableDefaultInternetAccess() {
        return this.enableDefaultInternetAccess;
    }

    public DomainJoinInfo domainJoinInfo() {
        return this.domainJoinInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDefaultInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainJoinInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageBuilderRequest)) {
            return false;
        }
        CreateImageBuilderRequest other = (CreateImageBuilderRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.imageName(), other.imageName()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.enableDefaultInternetAccess(), other.enableDefaultInternetAccess()) && Objects.equals(this.domainJoinInfo(), other.domainJoinInfo());
    }

    public String toString() {
        return ToString.builder((String)"CreateImageBuilderRequest").add("Name", (Object)this.name()).add("ImageName", (Object)this.imageName()).add("InstanceType", (Object)this.instanceType()).add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("VpcConfig", (Object)this.vpcConfig()).add("EnableDefaultInternetAccess", (Object)this.enableDefaultInternetAccess()).add("DomainJoinInfo", (Object)this.domainJoinInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "ImageName": {
                return Optional.of(clazz.cast(this.imageName()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.of(clazz.cast(this.displayName()));
            }
            case "VpcConfig": {
                return Optional.of(clazz.cast(this.vpcConfig()));
            }
            case "EnableDefaultInternetAccess": {
                return Optional.of(clazz.cast(this.enableDefaultInternetAccess()));
            }
            case "DomainJoinInfo": {
                return Optional.of(clazz.cast(this.domainJoinInfo()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String name;
        private String imageName;
        private String instanceType;
        private String description;
        private String displayName;
        private VpcConfig vpcConfig;
        private Boolean enableDefaultInternetAccess;
        private DomainJoinInfo domainJoinInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageBuilderRequest model) {
            super(model);
            this.name(model.name);
            this.imageName(model.imageName);
            this.instanceType(model.instanceType);
            this.description(model.description);
            this.displayName(model.displayName);
            this.vpcConfig(model.vpcConfig);
            this.enableDefaultInternetAccess(model.enableDefaultInternetAccess);
            this.domainJoinInfo(model.domainJoinInfo);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getImageName() {
            return this.imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return this.enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        public final DomainJoinInfo.Builder getDomainJoinInfo() {
            return this.domainJoinInfo != null ? this.domainJoinInfo.toBuilder() : null;
        }

        @Override
        public final Builder domainJoinInfo(DomainJoinInfo domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo;
            return this;
        }

        public final void setDomainJoinInfo(DomainJoinInfo.BuilderImpl domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo != null ? domainJoinInfo.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateImageBuilderRequest build() {
            return new CreateImageBuilderRequest(this);
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    CopyableBuilder<Builder, CreateImageBuilderRequest> {
        public Builder name(String var1);

        public Builder imageName(String var1);

        public Builder instanceType(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().apply(vpcConfig)).build());
        }

        public Builder enableDefaultInternetAccess(Boolean var1);

        public Builder domainJoinInfo(DomainJoinInfo var1);

        default public Builder domainJoinInfo(Consumer<DomainJoinInfo.Builder> domainJoinInfo) {
            return this.domainJoinInfo((DomainJoinInfo)((DomainJoinInfo.Builder)DomainJoinInfo.builder().apply(domainJoinInfo)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

