/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.appstream.model.ComputeCapacityStatus;
import software.amazon.awssdk.services.appstream.model.FleetError;
import software.amazon.awssdk.services.appstream.model.FleetErrorsCopier;
import software.amazon.awssdk.services.appstream.model.FleetState;
import software.amazon.awssdk.services.appstream.model.VpcConfig;
import software.amazon.awssdk.services.appstream.transform.FleetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Fleet
implements StructuredPojo,
ToCopyableBuilder<Builder, Fleet> {
    private final String arn;
    private final String name;
    private final String displayName;
    private final String description;
    private final String imageName;
    private final String instanceType;
    private final ComputeCapacityStatus computeCapacityStatus;
    private final Integer maxUserDurationInSeconds;
    private final Integer disconnectTimeoutInSeconds;
    private final String state;
    private final VpcConfig vpcConfig;
    private final Date createdTime;
    private final List<FleetError> fleetErrors;
    private final Boolean enableDefaultInternetAccess;

    private Fleet(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.imageName = builder.imageName;
        this.instanceType = builder.instanceType;
        this.computeCapacityStatus = builder.computeCapacityStatus;
        this.maxUserDurationInSeconds = builder.maxUserDurationInSeconds;
        this.disconnectTimeoutInSeconds = builder.disconnectTimeoutInSeconds;
        this.state = builder.state;
        this.vpcConfig = builder.vpcConfig;
        this.createdTime = builder.createdTime;
        this.fleetErrors = builder.fleetErrors;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String displayName() {
        return this.displayName;
    }

    public String description() {
        return this.description;
    }

    public String imageName() {
        return this.imageName;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public ComputeCapacityStatus computeCapacityStatus() {
        return this.computeCapacityStatus;
    }

    public Integer maxUserDurationInSeconds() {
        return this.maxUserDurationInSeconds;
    }

    public Integer disconnectTimeoutInSeconds() {
        return this.disconnectTimeoutInSeconds;
    }

    public String state() {
        return this.state;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public Date createdTime() {
        return this.createdTime;
    }

    public List<FleetError> fleetErrors() {
        return this.fleetErrors;
    }

    public Boolean enableDefaultInternetAccess() {
        return this.enableDefaultInternetAccess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.displayName() == null ? 0 : this.displayName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.imageName() == null ? 0 : this.imageName().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.computeCapacityStatus() == null ? 0 : this.computeCapacityStatus().hashCode());
        hashCode = 31 * hashCode + (this.maxUserDurationInSeconds() == null ? 0 : this.maxUserDurationInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.disconnectTimeoutInSeconds() == null ? 0 : this.disconnectTimeoutInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.vpcConfig() == null ? 0 : this.vpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.createdTime() == null ? 0 : this.createdTime().hashCode());
        hashCode = 31 * hashCode + (this.fleetErrors() == null ? 0 : this.fleetErrors().hashCode());
        hashCode = 31 * hashCode + (this.enableDefaultInternetAccess() == null ? 0 : this.enableDefaultInternetAccess().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Fleet)) {
            return false;
        }
        Fleet other = (Fleet)obj;
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.displayName() == null ^ this.displayName() == null) {
            return false;
        }
        if (other.displayName() != null && !other.displayName().equals(this.displayName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.imageName() == null ^ this.imageName() == null) {
            return false;
        }
        if (other.imageName() != null && !other.imageName().equals(this.imageName())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.computeCapacityStatus() == null ^ this.computeCapacityStatus() == null) {
            return false;
        }
        if (other.computeCapacityStatus() != null && !other.computeCapacityStatus().equals(this.computeCapacityStatus())) {
            return false;
        }
        if (other.maxUserDurationInSeconds() == null ^ this.maxUserDurationInSeconds() == null) {
            return false;
        }
        if (other.maxUserDurationInSeconds() != null && !other.maxUserDurationInSeconds().equals(this.maxUserDurationInSeconds())) {
            return false;
        }
        if (other.disconnectTimeoutInSeconds() == null ^ this.disconnectTimeoutInSeconds() == null) {
            return false;
        }
        if (other.disconnectTimeoutInSeconds() != null && !other.disconnectTimeoutInSeconds().equals(this.disconnectTimeoutInSeconds())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.vpcConfig() == null ^ this.vpcConfig() == null) {
            return false;
        }
        if (other.vpcConfig() != null && !other.vpcConfig().equals(this.vpcConfig())) {
            return false;
        }
        if (other.createdTime() == null ^ this.createdTime() == null) {
            return false;
        }
        if (other.createdTime() != null && !other.createdTime().equals(this.createdTime())) {
            return false;
        }
        if (other.fleetErrors() == null ^ this.fleetErrors() == null) {
            return false;
        }
        if (other.fleetErrors() != null && !other.fleetErrors().equals(this.fleetErrors())) {
            return false;
        }
        if (other.enableDefaultInternetAccess() == null ^ this.enableDefaultInternetAccess() == null) {
            return false;
        }
        return other.enableDefaultInternetAccess() == null || other.enableDefaultInternetAccess().equals(this.enableDefaultInternetAccess());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.displayName() != null) {
            sb.append("DisplayName: ").append(this.displayName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.imageName() != null) {
            sb.append("ImageName: ").append(this.imageName()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.computeCapacityStatus() != null) {
            sb.append("ComputeCapacityStatus: ").append(this.computeCapacityStatus()).append(",");
        }
        if (this.maxUserDurationInSeconds() != null) {
            sb.append("MaxUserDurationInSeconds: ").append(this.maxUserDurationInSeconds()).append(",");
        }
        if (this.disconnectTimeoutInSeconds() != null) {
            sb.append("DisconnectTimeoutInSeconds: ").append(this.disconnectTimeoutInSeconds()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.vpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.vpcConfig()).append(",");
        }
        if (this.createdTime() != null) {
            sb.append("CreatedTime: ").append(this.createdTime()).append(",");
        }
        if (this.fleetErrors() != null) {
            sb.append("FleetErrors: ").append(this.fleetErrors()).append(",");
        }
        if (this.enableDefaultInternetAccess() != null) {
            sb.append("EnableDefaultInternetAccess: ").append(this.enableDefaultInternetAccess()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FleetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String displayName;
        private String description;
        private String imageName;
        private String instanceType;
        private ComputeCapacityStatus computeCapacityStatus;
        private Integer maxUserDurationInSeconds;
        private Integer disconnectTimeoutInSeconds;
        private String state;
        private VpcConfig vpcConfig;
        private Date createdTime;
        private List<FleetError> fleetErrors;
        private Boolean enableDefaultInternetAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(Fleet model) {
            this.setArn(model.arn);
            this.setName(model.name);
            this.setDisplayName(model.displayName);
            this.setDescription(model.description);
            this.setImageName(model.imageName);
            this.setInstanceType(model.instanceType);
            this.setComputeCapacityStatus(model.computeCapacityStatus);
            this.setMaxUserDurationInSeconds(model.maxUserDurationInSeconds);
            this.setDisconnectTimeoutInSeconds(model.disconnectTimeoutInSeconds);
            this.setState(model.state);
            this.setVpcConfig(model.vpcConfig);
            this.setCreatedTime(model.createdTime);
            this.setFleetErrors(model.fleetErrors);
            this.setEnableDefaultInternetAccess(model.enableDefaultInternetAccess);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getImageName() {
            return this.imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final ComputeCapacityStatus getComputeCapacityStatus() {
            return this.computeCapacityStatus;
        }

        @Override
        public final Builder computeCapacityStatus(ComputeCapacityStatus computeCapacityStatus) {
            this.computeCapacityStatus = computeCapacityStatus;
            return this;
        }

        public final void setComputeCapacityStatus(ComputeCapacityStatus computeCapacityStatus) {
            this.computeCapacityStatus = computeCapacityStatus;
        }

        public final Integer getMaxUserDurationInSeconds() {
            return this.maxUserDurationInSeconds;
        }

        @Override
        public final Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
            return this;
        }

        public final void setMaxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
        }

        public final Integer getDisconnectTimeoutInSeconds() {
            return this.disconnectTimeoutInSeconds;
        }

        @Override
        public final Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
            return this;
        }

        public final void setDisconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(FleetState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(FleetState state) {
            this.state(state.toString());
        }

        public final VpcConfig getVpcConfig() {
            return this.vpcConfig;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
        }

        public final Date getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Date createdTime) {
            this.createdTime = StandardMemberCopier.copy((Date)createdTime);
            return this;
        }

        public final void setCreatedTime(Date createdTime) {
            this.createdTime = StandardMemberCopier.copy((Date)createdTime);
        }

        public final Collection<FleetError> getFleetErrors() {
            return this.fleetErrors;
        }

        @Override
        public final Builder fleetErrors(Collection<FleetError> fleetErrors) {
            this.fleetErrors = FleetErrorsCopier.copy(fleetErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetErrors(FleetError ... fleetErrors) {
            if (this.fleetErrors == null) {
                this.fleetErrors = new ArrayList<FleetError>(fleetErrors.length);
            }
            for (FleetError e : fleetErrors) {
                this.fleetErrors.add(e);
            }
            return this;
        }

        public final void setFleetErrors(Collection<FleetError> fleetErrors) {
            this.fleetErrors = FleetErrorsCopier.copy(fleetErrors);
        }

        @SafeVarargs
        public final void setFleetErrors(FleetError ... fleetErrors) {
            if (this.fleetErrors == null) {
                this.fleetErrors = new ArrayList<FleetError>(fleetErrors.length);
            }
            for (FleetError e : fleetErrors) {
                this.fleetErrors.add(e);
            }
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return this.enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        public Fleet build() {
            return new Fleet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Fleet> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder imageName(String var1);

        public Builder instanceType(String var1);

        public Builder computeCapacityStatus(ComputeCapacityStatus var1);

        public Builder maxUserDurationInSeconds(Integer var1);

        public Builder disconnectTimeoutInSeconds(Integer var1);

        public Builder state(String var1);

        public Builder state(FleetState var1);

        public Builder vpcConfig(VpcConfig var1);

        public Builder createdTime(Date var1);

        public Builder fleetErrors(Collection<FleetError> var1);

        public Builder fleetErrors(FleetError ... var1);

        public Builder enableDefaultInternetAccess(Boolean var1);
    }
}

