/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DNS Target record for a custom domain of this Amazon VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcDNSTarget implements SdkPojo, Serializable, ToCopyableBuilder<VpcDNSTarget.Builder, VpcDNSTarget> {
    private static final SdkField<String> VPC_INGRESS_CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcIngressConnectionArn").getter(getter(VpcDNSTarget::vpcIngressConnectionArn))
            .setter(setter(Builder::vpcIngressConnectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIngressConnectionArn").build())
            .build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(VpcDNSTarget::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(VpcDNSTarget::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VPC_INGRESS_CONNECTION_ARN_FIELD, VPC_ID_FIELD, DOMAIN_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vpcIngressConnectionArn;

    private final String vpcId;

    private final String domainName;

    private VpcDNSTarget(BuilderImpl builder) {
        this.vpcIngressConnectionArn = builder.vpcIngressConnectionArn;
        this.vpcId = builder.vpcId;
        this.domainName = builder.domainName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the VPC Ingress Connection that is associated with your service.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the VPC Ingress Connection that is associated with your service.
     */
    public final String vpcIngressConnectionArn() {
        return vpcIngressConnectionArn;
    }

    /**
     * <p>
     * The ID of the Amazon VPC that is associated with the custom domain name of the target DNS.
     * </p>
     * 
     * @return The ID of the Amazon VPC that is associated with the custom domain name of the target DNS.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The domain name of your target DNS that is associated with the Amazon VPC.
     * </p>
     * 
     * @return The domain name of your target DNS that is associated with the Amazon VPC.
     */
    public final String domainName() {
        return domainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcIngressConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcDNSTarget)) {
            return false;
        }
        VpcDNSTarget other = (VpcDNSTarget) obj;
        return Objects.equals(vpcIngressConnectionArn(), other.vpcIngressConnectionArn())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(domainName(), other.domainName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcDNSTarget").add("VpcIngressConnectionArn", vpcIngressConnectionArn()).add("VpcId", vpcId())
                .add("DomainName", domainName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcIngressConnectionArn":
            return Optional.ofNullable(clazz.cast(vpcIngressConnectionArn()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcIngressConnectionArn", VPC_INGRESS_CONNECTION_ARN_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcDNSTarget, T> g) {
        return obj -> g.apply((VpcDNSTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcDNSTarget> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the VPC Ingress Connection that is associated with your service.
         * </p>
         * 
         * @param vpcIngressConnectionArn
         *        The Amazon Resource Name (ARN) of the VPC Ingress Connection that is associated with your service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcIngressConnectionArn(String vpcIngressConnectionArn);

        /**
         * <p>
         * The ID of the Amazon VPC that is associated with the custom domain name of the target DNS.
         * </p>
         * 
         * @param vpcId
         *        The ID of the Amazon VPC that is associated with the custom domain name of the target DNS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The domain name of your target DNS that is associated with the Amazon VPC.
         * </p>
         * 
         * @param domainName
         *        The domain name of your target DNS that is associated with the Amazon VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);
    }

    static final class BuilderImpl implements Builder {
        private String vpcIngressConnectionArn;

        private String vpcId;

        private String domainName;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcDNSTarget model) {
            vpcIngressConnectionArn(model.vpcIngressConnectionArn);
            vpcId(model.vpcId);
            domainName(model.domainName);
        }

        public final String getVpcIngressConnectionArn() {
            return vpcIngressConnectionArn;
        }

        public final void setVpcIngressConnectionArn(String vpcIngressConnectionArn) {
            this.vpcIngressConnectionArn = vpcIngressConnectionArn;
        }

        @Override
        public final Builder vpcIngressConnectionArn(String vpcIngressConnectionArn) {
            this.vpcIngressConnectionArn = vpcIngressConnectionArn;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        @Override
        public VpcDNSTarget build() {
            return new VpcDNSTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
