/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVpcIngressConnectionRequest extends AppRunnerRequest implements
        ToCopyableBuilder<UpdateVpcIngressConnectionRequest.Builder, UpdateVpcIngressConnectionRequest> {
    private static final SdkField<String> VPC_INGRESS_CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcIngressConnectionArn").getter(getter(UpdateVpcIngressConnectionRequest::vpcIngressConnectionArn))
            .setter(setter(Builder::vpcIngressConnectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIngressConnectionArn").build())
            .build();

    private static final SdkField<IngressVpcConfiguration> INGRESS_VPC_CONFIGURATION_FIELD = SdkField
            .<IngressVpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("IngressVpcConfiguration")
            .getter(getter(UpdateVpcIngressConnectionRequest::ingressVpcConfiguration))
            .setter(setter(Builder::ingressVpcConfiguration)).constructor(IngressVpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressVpcConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VPC_INGRESS_CONNECTION_ARN_FIELD, INGRESS_VPC_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String vpcIngressConnectionArn;

    private final IngressVpcConfiguration ingressVpcConfiguration;

    private UpdateVpcIngressConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.vpcIngressConnectionArn = builder.vpcIngressConnectionArn;
        this.ingressVpcConfiguration = builder.ingressVpcConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (Arn) for the App Runner VPC Ingress Connection resource that you want to update.
     * </p>
     * 
     * @return The Amazon Resource Name (Arn) for the App Runner VPC Ingress Connection resource that you want to
     *         update.
     */
    public final String vpcIngressConnectionArn() {
        return vpcIngressConnectionArn;
    }

    /**
     * <p>
     * Specifications for the customer’s Amazon VPC and the related Amazon Web Services PrivateLink VPC endpoint that
     * are used to update the VPC Ingress Connection resource.
     * </p>
     * 
     * @return Specifications for the customer’s Amazon VPC and the related Amazon Web Services PrivateLink VPC endpoint
     *         that are used to update the VPC Ingress Connection resource.
     */
    public final IngressVpcConfiguration ingressVpcConfiguration() {
        return ingressVpcConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcIngressConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(ingressVpcConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVpcIngressConnectionRequest)) {
            return false;
        }
        UpdateVpcIngressConnectionRequest other = (UpdateVpcIngressConnectionRequest) obj;
        return Objects.equals(vpcIngressConnectionArn(), other.vpcIngressConnectionArn())
                && Objects.equals(ingressVpcConfiguration(), other.ingressVpcConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVpcIngressConnectionRequest").add("VpcIngressConnectionArn", vpcIngressConnectionArn())
                .add("IngressVpcConfiguration", ingressVpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcIngressConnectionArn":
            return Optional.ofNullable(clazz.cast(vpcIngressConnectionArn()));
        case "IngressVpcConfiguration":
            return Optional.ofNullable(clazz.cast(ingressVpcConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcIngressConnectionArn", VPC_INGRESS_CONNECTION_ARN_FIELD);
        map.put("IngressVpcConfiguration", INGRESS_VPC_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVpcIngressConnectionRequest, T> g) {
        return obj -> g.apply((UpdateVpcIngressConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppRunnerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateVpcIngressConnectionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (Arn) for the App Runner VPC Ingress Connection resource that you want to update.
         * </p>
         * 
         * @param vpcIngressConnectionArn
         *        The Amazon Resource Name (Arn) for the App Runner VPC Ingress Connection resource that you want to
         *        update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcIngressConnectionArn(String vpcIngressConnectionArn);

        /**
         * <p>
         * Specifications for the customer’s Amazon VPC and the related Amazon Web Services PrivateLink VPC endpoint
         * that are used to update the VPC Ingress Connection resource.
         * </p>
         * 
         * @param ingressVpcConfiguration
         *        Specifications for the customer’s Amazon VPC and the related Amazon Web Services PrivateLink VPC
         *        endpoint that are used to update the VPC Ingress Connection resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingressVpcConfiguration(IngressVpcConfiguration ingressVpcConfiguration);

        /**
         * <p>
         * Specifications for the customer’s Amazon VPC and the related Amazon Web Services PrivateLink VPC endpoint
         * that are used to update the VPC Ingress Connection resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngressVpcConfiguration.Builder} avoiding
         * the need to create one manually via {@link IngressVpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngressVpcConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #ingressVpcConfiguration(IngressVpcConfiguration)}.
         * 
         * @param ingressVpcConfiguration
         *        a consumer that will call methods on {@link IngressVpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingressVpcConfiguration(IngressVpcConfiguration)
         */
        default Builder ingressVpcConfiguration(Consumer<IngressVpcConfiguration.Builder> ingressVpcConfiguration) {
            return ingressVpcConfiguration(IngressVpcConfiguration.builder().applyMutation(ingressVpcConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppRunnerRequest.BuilderImpl implements Builder {
        private String vpcIngressConnectionArn;

        private IngressVpcConfiguration ingressVpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVpcIngressConnectionRequest model) {
            super(model);
            vpcIngressConnectionArn(model.vpcIngressConnectionArn);
            ingressVpcConfiguration(model.ingressVpcConfiguration);
        }

        public final String getVpcIngressConnectionArn() {
            return vpcIngressConnectionArn;
        }

        public final void setVpcIngressConnectionArn(String vpcIngressConnectionArn) {
            this.vpcIngressConnectionArn = vpcIngressConnectionArn;
        }

        @Override
        public final Builder vpcIngressConnectionArn(String vpcIngressConnectionArn) {
            this.vpcIngressConnectionArn = vpcIngressConnectionArn;
            return this;
        }

        public final IngressVpcConfiguration.Builder getIngressVpcConfiguration() {
            return ingressVpcConfiguration != null ? ingressVpcConfiguration.toBuilder() : null;
        }

        public final void setIngressVpcConfiguration(IngressVpcConfiguration.BuilderImpl ingressVpcConfiguration) {
            this.ingressVpcConfiguration = ingressVpcConfiguration != null ? ingressVpcConfiguration.build() : null;
        }

        @Override
        public final Builder ingressVpcConfiguration(IngressVpcConfiguration ingressVpcConfiguration) {
            this.ingressVpcConfiguration = ingressVpcConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVpcIngressConnectionRequest build() {
            return new UpdateVpcIngressConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
