/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ObservabilityConfigurationSummaryListCopier {
    static List<ObservabilityConfigurationSummary> copy(
            Collection<? extends ObservabilityConfigurationSummary> observabilityConfigurationSummaryListParam) {
        List<ObservabilityConfigurationSummary> list;
        if (observabilityConfigurationSummaryListParam == null
                || observabilityConfigurationSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ObservabilityConfigurationSummary> modifiableList = new ArrayList<>(
                    observabilityConfigurationSummaryListParam.size());
            observabilityConfigurationSummaryListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ObservabilityConfigurationSummary> copyFromBuilder(
            Collection<? extends ObservabilityConfigurationSummary.Builder> observabilityConfigurationSummaryListParam) {
        List<ObservabilityConfigurationSummary> list;
        if (observabilityConfigurationSummaryListParam == null
                || observabilityConfigurationSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ObservabilityConfigurationSummary> modifiableList = new ArrayList<>(
                    observabilityConfigurationSummaryListParam.size());
            observabilityConfigurationSummaryListParam.forEach(entry -> {
                ObservabilityConfigurationSummary member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ObservabilityConfigurationSummary.Builder> copyToBuilder(
            Collection<? extends ObservabilityConfigurationSummary> observabilityConfigurationSummaryListParam) {
        List<ObservabilityConfigurationSummary.Builder> list;
        if (observabilityConfigurationSummaryListParam == null
                || observabilityConfigurationSummaryListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ObservabilityConfigurationSummary.Builder> modifiableList = new ArrayList<>(
                    observabilityConfigurationSummaryListParam.size());
            observabilityConfigurationSummaryListParam.forEach(entry -> {
                ObservabilityConfigurationSummary.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
