/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a source code repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeRepository implements SdkPojo, Serializable, ToCopyableBuilder<CodeRepository.Builder, CodeRepository> {
    private static final SdkField<String> REPOSITORY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryUrl").getter(getter(CodeRepository::repositoryUrl)).setter(setter(Builder::repositoryUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryUrl").build()).build();

    private static final SdkField<SourceCodeVersion> SOURCE_CODE_VERSION_FIELD = SdkField
            .<SourceCodeVersion> builder(MarshallingType.SDK_POJO).memberName("SourceCodeVersion")
            .getter(getter(CodeRepository::sourceCodeVersion)).setter(setter(Builder::sourceCodeVersion))
            .constructor(SourceCodeVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCodeVersion").build()).build();

    private static final SdkField<CodeConfiguration> CODE_CONFIGURATION_FIELD = SdkField
            .<CodeConfiguration> builder(MarshallingType.SDK_POJO).memberName("CodeConfiguration")
            .getter(getter(CodeRepository::codeConfiguration)).setter(setter(Builder::codeConfiguration))
            .constructor(CodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeConfiguration").build()).build();

    private static final SdkField<String> SOURCE_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceDirectory").getter(getter(CodeRepository::sourceDirectory))
            .setter(setter(Builder::sourceDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDirectory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_URL_FIELD,
            SOURCE_CODE_VERSION_FIELD, CODE_CONFIGURATION_FIELD, SOURCE_DIRECTORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String repositoryUrl;

    private final SourceCodeVersion sourceCodeVersion;

    private final CodeConfiguration codeConfiguration;

    private final String sourceDirectory;

    private CodeRepository(BuilderImpl builder) {
        this.repositoryUrl = builder.repositoryUrl;
        this.sourceCodeVersion = builder.sourceCodeVersion;
        this.codeConfiguration = builder.codeConfiguration;
        this.sourceDirectory = builder.sourceDirectory;
    }

    /**
     * <p>
     * The location of the repository that contains the source code.
     * </p>
     * 
     * @return The location of the repository that contains the source code.
     */
    public final String repositoryUrl() {
        return repositoryUrl;
    }

    /**
     * <p>
     * The version that should be used within the source code repository.
     * </p>
     * 
     * @return The version that should be used within the source code repository.
     */
    public final SourceCodeVersion sourceCodeVersion() {
        return sourceCodeVersion;
    }

    /**
     * <p>
     * Configuration for building and running the service from a source code repository.
     * </p>
     * <note>
     * <p>
     * <code>CodeConfiguration</code> is required only for <code>CreateService</code> request.
     * </p>
     * </note>
     * 
     * @return Configuration for building and running the service from a source code repository.</p> <note>
     *         <p>
     *         <code>CodeConfiguration</code> is required only for <code>CreateService</code> request.
     *         </p>
     */
    public final CodeConfiguration codeConfiguration() {
        return codeConfiguration;
    }

    /**
     * <p>
     * The path of the directory that stores source code and configuration files. The build and start commands also
     * execute from here. The path is absolute from root and, if not specified, defaults to the repository root.
     * </p>
     * 
     * @return The path of the directory that stores source code and configuration files. The build and start commands
     *         also execute from here. The path is absolute from root and, if not specified, defaults to the repository
     *         root.
     */
    public final String sourceDirectory() {
        return sourceDirectory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCodeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(codeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDirectory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeRepository)) {
            return false;
        }
        CodeRepository other = (CodeRepository) obj;
        return Objects.equals(repositoryUrl(), other.repositoryUrl())
                && Objects.equals(sourceCodeVersion(), other.sourceCodeVersion())
                && Objects.equals(codeConfiguration(), other.codeConfiguration())
                && Objects.equals(sourceDirectory(), other.sourceDirectory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeRepository").add("RepositoryUrl", repositoryUrl())
                .add("SourceCodeVersion", sourceCodeVersion()).add("CodeConfiguration", codeConfiguration())
                .add("SourceDirectory", sourceDirectory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RepositoryUrl":
            return Optional.ofNullable(clazz.cast(repositoryUrl()));
        case "SourceCodeVersion":
            return Optional.ofNullable(clazz.cast(sourceCodeVersion()));
        case "CodeConfiguration":
            return Optional.ofNullable(clazz.cast(codeConfiguration()));
        case "SourceDirectory":
            return Optional.ofNullable(clazz.cast(sourceDirectory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RepositoryUrl", REPOSITORY_URL_FIELD);
        map.put("SourceCodeVersion", SOURCE_CODE_VERSION_FIELD);
        map.put("CodeConfiguration", CODE_CONFIGURATION_FIELD);
        map.put("SourceDirectory", SOURCE_DIRECTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeRepository, T> g) {
        return obj -> g.apply((CodeRepository) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeRepository> {
        /**
         * <p>
         * The location of the repository that contains the source code.
         * </p>
         * 
         * @param repositoryUrl
         *        The location of the repository that contains the source code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryUrl(String repositoryUrl);

        /**
         * <p>
         * The version that should be used within the source code repository.
         * </p>
         * 
         * @param sourceCodeVersion
         *        The version that should be used within the source code repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCodeVersion(SourceCodeVersion sourceCodeVersion);

        /**
         * <p>
         * The version that should be used within the source code repository.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceCodeVersion.Builder} avoiding the
         * need to create one manually via {@link SourceCodeVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceCodeVersion.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceCodeVersion(SourceCodeVersion)}.
         * 
         * @param sourceCodeVersion
         *        a consumer that will call methods on {@link SourceCodeVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceCodeVersion(SourceCodeVersion)
         */
        default Builder sourceCodeVersion(Consumer<SourceCodeVersion.Builder> sourceCodeVersion) {
            return sourceCodeVersion(SourceCodeVersion.builder().applyMutation(sourceCodeVersion).build());
        }

        /**
         * <p>
         * Configuration for building and running the service from a source code repository.
         * </p>
         * <note>
         * <p>
         * <code>CodeConfiguration</code> is required only for <code>CreateService</code> request.
         * </p>
         * </note>
         * 
         * @param codeConfiguration
         *        Configuration for building and running the service from a source code repository.</p> <note>
         *        <p>
         *        <code>CodeConfiguration</code> is required only for <code>CreateService</code> request.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeConfiguration(CodeConfiguration codeConfiguration);

        /**
         * <p>
         * Configuration for building and running the service from a source code repository.
         * </p>
         * <note>
         * <p>
         * <code>CodeConfiguration</code> is required only for <code>CreateService</code> request.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link CodeConfiguration.Builder}
         * avoiding the need to create one manually via {@link CodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CodeConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #codeConfiguration(CodeConfiguration)}.
         * 
         * @param codeConfiguration
         *        a consumer that will call methods on {@link CodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeConfiguration(CodeConfiguration)
         */
        default Builder codeConfiguration(Consumer<CodeConfiguration.Builder> codeConfiguration) {
            return codeConfiguration(CodeConfiguration.builder().applyMutation(codeConfiguration).build());
        }

        /**
         * <p>
         * The path of the directory that stores source code and configuration files. The build and start commands also
         * execute from here. The path is absolute from root and, if not specified, defaults to the repository root.
         * </p>
         * 
         * @param sourceDirectory
         *        The path of the directory that stores source code and configuration files. The build and start
         *        commands also execute from here. The path is absolute from root and, if not specified, defaults to the
         *        repository root.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDirectory(String sourceDirectory);
    }

    static final class BuilderImpl implements Builder {
        private String repositoryUrl;

        private SourceCodeVersion sourceCodeVersion;

        private CodeConfiguration codeConfiguration;

        private String sourceDirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeRepository model) {
            repositoryUrl(model.repositoryUrl);
            sourceCodeVersion(model.sourceCodeVersion);
            codeConfiguration(model.codeConfiguration);
            sourceDirectory(model.sourceDirectory);
        }

        public final String getRepositoryUrl() {
            return repositoryUrl;
        }

        public final void setRepositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
        }

        @Override
        public final Builder repositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            return this;
        }

        public final SourceCodeVersion.Builder getSourceCodeVersion() {
            return sourceCodeVersion != null ? sourceCodeVersion.toBuilder() : null;
        }

        public final void setSourceCodeVersion(SourceCodeVersion.BuilderImpl sourceCodeVersion) {
            this.sourceCodeVersion = sourceCodeVersion != null ? sourceCodeVersion.build() : null;
        }

        @Override
        public final Builder sourceCodeVersion(SourceCodeVersion sourceCodeVersion) {
            this.sourceCodeVersion = sourceCodeVersion;
            return this;
        }

        public final CodeConfiguration.Builder getCodeConfiguration() {
            return codeConfiguration != null ? codeConfiguration.toBuilder() : null;
        }

        public final void setCodeConfiguration(CodeConfiguration.BuilderImpl codeConfiguration) {
            this.codeConfiguration = codeConfiguration != null ? codeConfiguration.build() : null;
        }

        @Override
        public final Builder codeConfiguration(CodeConfiguration codeConfiguration) {
            this.codeConfiguration = codeConfiguration;
            return this;
        }

        public final String getSourceDirectory() {
            return sourceDirectory;
        }

        public final void setSourceDirectory(String sourceDirectory) {
            this.sourceDirectory = sourceDirectory;
        }

        @Override
        public final Builder sourceDirectory(String sourceDirectory) {
            this.sourceDirectory = sourceDirectory;
            return this;
        }

        @Override
        public CodeRepository build() {
            return new CodeRepository(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
