/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateCustomDomainResponse extends AppRunnerResponse implements
        ToCopyableBuilder<AssociateCustomDomainResponse.Builder, AssociateCustomDomainResponse> {
    private static final SdkField<String> DNS_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DNSTarget").getter(getter(AssociateCustomDomainResponse::dnsTarget)).setter(setter(Builder::dnsTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DNSTarget").build()).build();

    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceArn").getter(getter(AssociateCustomDomainResponse::serviceArn))
            .setter(setter(Builder::serviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceArn").build()).build();

    private static final SdkField<CustomDomain> CUSTOM_DOMAIN_FIELD = SdkField.<CustomDomain> builder(MarshallingType.SDK_POJO)
            .memberName("CustomDomain").getter(getter(AssociateCustomDomainResponse::customDomain))
            .setter(setter(Builder::customDomain)).constructor(CustomDomain::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomain").build()).build();

    private static final SdkField<List<VpcDNSTarget>> VPC_DNS_TARGETS_FIELD = SdkField
            .<List<VpcDNSTarget>> builder(MarshallingType.LIST)
            .memberName("VpcDNSTargets")
            .getter(getter(AssociateCustomDomainResponse::vpcDNSTargets))
            .setter(setter(Builder::vpcDNSTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcDNSTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcDNSTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcDNSTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_TARGET_FIELD,
            SERVICE_ARN_FIELD, CUSTOM_DOMAIN_FIELD, VPC_DNS_TARGETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dnsTarget;

    private final String serviceArn;

    private final CustomDomain customDomain;

    private final List<VpcDNSTarget> vpcDNSTargets;

    private AssociateCustomDomainResponse(BuilderImpl builder) {
        super(builder);
        this.dnsTarget = builder.dnsTarget;
        this.serviceArn = builder.serviceArn;
        this.customDomain = builder.customDomain;
        this.vpcDNSTargets = builder.vpcDNSTargets;
    }

    /**
     * <p>
     * The App Runner subdomain of the App Runner service. The custom domain name is mapped to this target name.
     * </p>
     * 
     * @return The App Runner subdomain of the App Runner service. The custom domain name is mapped to this target name.
     */
    public final String dnsTarget() {
        return dnsTarget;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the App Runner service with which a custom domain name is associated.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the App Runner service with which a custom domain name is associated.
     */
    public final String serviceArn() {
        return serviceArn;
    }

    /**
     * <p>
     * A description of the domain name that's being associated.
     * </p>
     * 
     * @return A description of the domain name that's being associated.
     */
    public final CustomDomain customDomain() {
        return customDomain;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcDNSTargets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcDNSTargets() {
        return vpcDNSTargets != null && !(vpcDNSTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * DNS Target records for the custom domains of this Amazon VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcDNSTargets} method.
     * </p>
     * 
     * @return DNS Target records for the custom domains of this Amazon VPC.
     */
    public final List<VpcDNSTarget> vpcDNSTargets() {
        return vpcDNSTargets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dnsTarget());
        hashCode = 31 * hashCode + Objects.hashCode(serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(customDomain());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcDNSTargets() ? vpcDNSTargets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateCustomDomainResponse)) {
            return false;
        }
        AssociateCustomDomainResponse other = (AssociateCustomDomainResponse) obj;
        return Objects.equals(dnsTarget(), other.dnsTarget()) && Objects.equals(serviceArn(), other.serviceArn())
                && Objects.equals(customDomain(), other.customDomain()) && hasVpcDNSTargets() == other.hasVpcDNSTargets()
                && Objects.equals(vpcDNSTargets(), other.vpcDNSTargets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateCustomDomainResponse").add("DNSTarget", dnsTarget()).add("ServiceArn", serviceArn())
                .add("CustomDomain", customDomain()).add("VpcDNSTargets", hasVpcDNSTargets() ? vpcDNSTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DNSTarget":
            return Optional.ofNullable(clazz.cast(dnsTarget()));
        case "ServiceArn":
            return Optional.ofNullable(clazz.cast(serviceArn()));
        case "CustomDomain":
            return Optional.ofNullable(clazz.cast(customDomain()));
        case "VpcDNSTargets":
            return Optional.ofNullable(clazz.cast(vpcDNSTargets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DNSTarget", DNS_TARGET_FIELD);
        map.put("ServiceArn", SERVICE_ARN_FIELD);
        map.put("CustomDomain", CUSTOM_DOMAIN_FIELD);
        map.put("VpcDNSTargets", VPC_DNS_TARGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateCustomDomainResponse, T> g) {
        return obj -> g.apply((AssociateCustomDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppRunnerResponse.Builder, SdkPojo, CopyableBuilder<Builder, AssociateCustomDomainResponse> {
        /**
         * <p>
         * The App Runner subdomain of the App Runner service. The custom domain name is mapped to this target name.
         * </p>
         * 
         * @param dnsTarget
         *        The App Runner subdomain of the App Runner service. The custom domain name is mapped to this target
         *        name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsTarget(String dnsTarget);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the App Runner service with which a custom domain name is associated.
         * </p>
         * 
         * @param serviceArn
         *        The Amazon Resource Name (ARN) of the App Runner service with which a custom domain name is
         *        associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArn(String serviceArn);

        /**
         * <p>
         * A description of the domain name that's being associated.
         * </p>
         * 
         * @param customDomain
         *        A description of the domain name that's being associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomain(CustomDomain customDomain);

        /**
         * <p>
         * A description of the domain name that's being associated.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomDomain.Builder} avoiding the need
         * to create one manually via {@link CustomDomain#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomDomain.Builder#build()} is called immediately and its
         * result is passed to {@link #customDomain(CustomDomain)}.
         * 
         * @param customDomain
         *        a consumer that will call methods on {@link CustomDomain.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customDomain(CustomDomain)
         */
        default Builder customDomain(Consumer<CustomDomain.Builder> customDomain) {
            return customDomain(CustomDomain.builder().applyMutation(customDomain).build());
        }

        /**
         * <p>
         * DNS Target records for the custom domains of this Amazon VPC.
         * </p>
         * 
         * @param vpcDNSTargets
         *        DNS Target records for the custom domains of this Amazon VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcDNSTargets(Collection<VpcDNSTarget> vpcDNSTargets);

        /**
         * <p>
         * DNS Target records for the custom domains of this Amazon VPC.
         * </p>
         * 
         * @param vpcDNSTargets
         *        DNS Target records for the custom domains of this Amazon VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcDNSTargets(VpcDNSTarget... vpcDNSTargets);

        /**
         * <p>
         * DNS Target records for the custom domains of this Amazon VPC.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apprunner.model.VpcDNSTarget.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.apprunner.model.VpcDNSTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apprunner.model.VpcDNSTarget.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcDNSTargets(List<VpcDNSTarget>)}.
         * 
         * @param vpcDNSTargets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apprunner.model.VpcDNSTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcDNSTargets(java.util.Collection<VpcDNSTarget>)
         */
        Builder vpcDNSTargets(Consumer<VpcDNSTarget.Builder>... vpcDNSTargets);
    }

    static final class BuilderImpl extends AppRunnerResponse.BuilderImpl implements Builder {
        private String dnsTarget;

        private String serviceArn;

        private CustomDomain customDomain;

        private List<VpcDNSTarget> vpcDNSTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateCustomDomainResponse model) {
            super(model);
            dnsTarget(model.dnsTarget);
            serviceArn(model.serviceArn);
            customDomain(model.customDomain);
            vpcDNSTargets(model.vpcDNSTargets);
        }

        public final String getDnsTarget() {
            return dnsTarget;
        }

        public final void setDnsTarget(String dnsTarget) {
            this.dnsTarget = dnsTarget;
        }

        @Override
        public final Builder dnsTarget(String dnsTarget) {
            this.dnsTarget = dnsTarget;
            return this;
        }

        public final String getServiceArn() {
            return serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final CustomDomain.Builder getCustomDomain() {
            return customDomain != null ? customDomain.toBuilder() : null;
        }

        public final void setCustomDomain(CustomDomain.BuilderImpl customDomain) {
            this.customDomain = customDomain != null ? customDomain.build() : null;
        }

        @Override
        public final Builder customDomain(CustomDomain customDomain) {
            this.customDomain = customDomain;
            return this;
        }

        public final List<VpcDNSTarget.Builder> getVpcDNSTargets() {
            List<VpcDNSTarget.Builder> result = VpcDNSTargetListCopier.copyToBuilder(this.vpcDNSTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcDNSTargets(Collection<VpcDNSTarget.BuilderImpl> vpcDNSTargets) {
            this.vpcDNSTargets = VpcDNSTargetListCopier.copyFromBuilder(vpcDNSTargets);
        }

        @Override
        public final Builder vpcDNSTargets(Collection<VpcDNSTarget> vpcDNSTargets) {
            this.vpcDNSTargets = VpcDNSTargetListCopier.copy(vpcDNSTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcDNSTargets(VpcDNSTarget... vpcDNSTargets) {
            vpcDNSTargets(Arrays.asList(vpcDNSTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcDNSTargets(Consumer<VpcDNSTarget.Builder>... vpcDNSTargets) {
            vpcDNSTargets(Stream.of(vpcDNSTargets).map(c -> VpcDNSTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AssociateCustomDomainResponse build() {
            return new AssociateCustomDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
