/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apprunner.model.AppRunnerResponse;
import software.amazon.awssdk.services.apprunner.model.VpcIngressConnectionSummary;
import software.amazon.awssdk.services.apprunner.model.VpcIngressConnectionSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVpcIngressConnectionsResponse
extends AppRunnerResponse
implements ToCopyableBuilder<Builder, ListVpcIngressConnectionsResponse> {
    private static final SdkField<List<VpcIngressConnectionSummary>> VPC_INGRESS_CONNECTION_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcIngressConnectionSummaryList").getter(ListVpcIngressConnectionsResponse.getter(ListVpcIngressConnectionsResponse::vpcIngressConnectionSummaryList)).setter(ListVpcIngressConnectionsResponse.setter(Builder::vpcIngressConnectionSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIngressConnectionSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcIngressConnectionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListVpcIngressConnectionsResponse.getter(ListVpcIngressConnectionsResponse::nextToken)).setter(ListVpcIngressConnectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_INGRESS_CONNECTION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListVpcIngressConnectionsResponse.memberNameToFieldInitializer();
    private final List<VpcIngressConnectionSummary> vpcIngressConnectionSummaryList;
    private final String nextToken;

    private ListVpcIngressConnectionsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcIngressConnectionSummaryList = builder.vpcIngressConnectionSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVpcIngressConnectionSummaryList() {
        return this.vpcIngressConnectionSummaryList != null && !(this.vpcIngressConnectionSummaryList instanceof SdkAutoConstructList);
    }

    public final List<VpcIngressConnectionSummary> vpcIngressConnectionSummaryList() {
        return this.vpcIngressConnectionSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcIngressConnectionSummaryList() ? this.vpcIngressConnectionSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVpcIngressConnectionsResponse)) {
            return false;
        }
        ListVpcIngressConnectionsResponse other = (ListVpcIngressConnectionsResponse)((Object)obj);
        return this.hasVpcIngressConnectionSummaryList() == other.hasVpcIngressConnectionSummaryList() && Objects.equals(this.vpcIngressConnectionSummaryList(), other.vpcIngressConnectionSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListVpcIngressConnectionsResponse").add("VpcIngressConnectionSummaryList", this.hasVpcIngressConnectionSummaryList() ? this.vpcIngressConnectionSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcIngressConnectionSummaryList": {
                return Optional.ofNullable(clazz.cast(this.vpcIngressConnectionSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VpcIngressConnectionSummaryList", VPC_INGRESS_CONNECTION_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVpcIngressConnectionsResponse, T> g) {
        return obj -> g.apply((ListVpcIngressConnectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppRunnerResponse.BuilderImpl
    implements Builder {
        private List<VpcIngressConnectionSummary> vpcIngressConnectionSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVpcIngressConnectionsResponse model) {
            super(model);
            this.vpcIngressConnectionSummaryList(model.vpcIngressConnectionSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<VpcIngressConnectionSummary.Builder> getVpcIngressConnectionSummaryList() {
            List<VpcIngressConnectionSummary.Builder> result = VpcIngressConnectionSummaryListCopier.copyToBuilder(this.vpcIngressConnectionSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcIngressConnectionSummaryList(Collection<VpcIngressConnectionSummary.BuilderImpl> vpcIngressConnectionSummaryList) {
            this.vpcIngressConnectionSummaryList = VpcIngressConnectionSummaryListCopier.copyFromBuilder(vpcIngressConnectionSummaryList);
        }

        @Override
        public final Builder vpcIngressConnectionSummaryList(Collection<VpcIngressConnectionSummary> vpcIngressConnectionSummaryList) {
            this.vpcIngressConnectionSummaryList = VpcIngressConnectionSummaryListCopier.copy(vpcIngressConnectionSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcIngressConnectionSummaryList(VpcIngressConnectionSummary ... vpcIngressConnectionSummaryList) {
            this.vpcIngressConnectionSummaryList(Arrays.asList(vpcIngressConnectionSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcIngressConnectionSummaryList(Consumer<VpcIngressConnectionSummary.Builder> ... vpcIngressConnectionSummaryList) {
            this.vpcIngressConnectionSummaryList(Stream.of(vpcIngressConnectionSummaryList).map(c -> (VpcIngressConnectionSummary)((VpcIngressConnectionSummary.Builder)VpcIngressConnectionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListVpcIngressConnectionsResponse build() {
            return new ListVpcIngressConnectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppRunnerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVpcIngressConnectionsResponse> {
        public Builder vpcIngressConnectionSummaryList(Collection<VpcIngressConnectionSummary> var1);

        public Builder vpcIngressConnectionSummaryList(VpcIngressConnectionSummary ... var1);

        public Builder vpcIngressConnectionSummaryList(Consumer<VpcIngressConnectionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

