/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apprunner.model.StringListCopier;
import software.amazon.awssdk.services.apprunner.model.VpcConnectorStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcConnector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcConnector> {
    private static final SdkField<String> VPC_CONNECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcConnectorName").getter(VpcConnector.getter(VpcConnector::vpcConnectorName)).setter(VpcConnector.setter(Builder::vpcConnectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConnectorName").build()}).build();
    private static final SdkField<String> VPC_CONNECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcConnectorArn").getter(VpcConnector.getter(VpcConnector::vpcConnectorArn)).setter(VpcConnector.setter(Builder::vpcConnectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConnectorArn").build()}).build();
    private static final SdkField<Integer> VPC_CONNECTOR_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VpcConnectorRevision").getter(VpcConnector.getter(VpcConnector::vpcConnectorRevision)).setter(VpcConnector.setter(Builder::vpcConnectorRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConnectorRevision").build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subnets").getter(VpcConnector.getter(VpcConnector::subnets)).setter(VpcConnector.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(VpcConnector.getter(VpcConnector::securityGroups)).setter(VpcConnector.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(VpcConnector.getter(VpcConnector::statusAsString)).setter(VpcConnector.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(VpcConnector.getter(VpcConnector::createdAt)).setter(VpcConnector.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> DELETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeletedAt").getter(VpcConnector.getter(VpcConnector::deletedAt)).setter(VpcConnector.setter(Builder::deletedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONNECTOR_NAME_FIELD, VPC_CONNECTOR_ARN_FIELD, VPC_CONNECTOR_REVISION_FIELD, SUBNETS_FIELD, SECURITY_GROUPS_FIELD, STATUS_FIELD, CREATED_AT_FIELD, DELETED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VpcConnector.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String vpcConnectorName;
    private final String vpcConnectorArn;
    private final Integer vpcConnectorRevision;
    private final List<String> subnets;
    private final List<String> securityGroups;
    private final String status;
    private final Instant createdAt;
    private final Instant deletedAt;

    private VpcConnector(BuilderImpl builder) {
        this.vpcConnectorName = builder.vpcConnectorName;
        this.vpcConnectorArn = builder.vpcConnectorArn;
        this.vpcConnectorRevision = builder.vpcConnectorRevision;
        this.subnets = builder.subnets;
        this.securityGroups = builder.securityGroups;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.deletedAt = builder.deletedAt;
    }

    public final String vpcConnectorName() {
        return this.vpcConnectorName;
    }

    public final String vpcConnectorArn() {
        return this.vpcConnectorArn;
    }

    public final Integer vpcConnectorRevision() {
        return this.vpcConnectorRevision;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<String> subnets() {
        return this.subnets;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final VpcConnectorStatus status() {
        return VpcConnectorStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant deletedAt() {
        return this.deletedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectorRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConnector)) {
            return false;
        }
        VpcConnector other = (VpcConnector)obj;
        return Objects.equals(this.vpcConnectorName(), other.vpcConnectorName()) && Objects.equals(this.vpcConnectorArn(), other.vpcConnectorArn()) && Objects.equals(this.vpcConnectorRevision(), other.vpcConnectorRevision()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.deletedAt(), other.deletedAt());
    }

    public final String toString() {
        return ToString.builder((String)"VpcConnector").add("VpcConnectorName", (Object)this.vpcConnectorName()).add("VpcConnectorArn", (Object)this.vpcConnectorArn()).add("VpcConnectorRevision", (Object)this.vpcConnectorRevision()).add("Subnets", this.hasSubnets() ? this.subnets() : null).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("DeletedAt", (Object)this.deletedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcConnectorName": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectorName()));
            }
            case "VpcConnectorArn": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectorArn()));
            }
            case "VpcConnectorRevision": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectorRevision()));
            }
            case "Subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DeletedAt": {
                return Optional.ofNullable(clazz.cast(this.deletedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VpcConnectorName", VPC_CONNECTOR_NAME_FIELD);
        map.put("VpcConnectorArn", VPC_CONNECTOR_ARN_FIELD);
        map.put("VpcConnectorRevision", VPC_CONNECTOR_REVISION_FIELD);
        map.put("Subnets", SUBNETS_FIELD);
        map.put("SecurityGroups", SECURITY_GROUPS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("DeletedAt", DELETED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcConnector, T> g) {
        return obj -> g.apply((VpcConnector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcConnectorName;
        private String vpcConnectorArn;
        private Integer vpcConnectorRevision;
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Instant createdAt;
        private Instant deletedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConnector model) {
            this.vpcConnectorName(model.vpcConnectorName);
            this.vpcConnectorArn(model.vpcConnectorArn);
            this.vpcConnectorRevision(model.vpcConnectorRevision);
            this.subnets(model.subnets);
            this.securityGroups(model.securityGroups);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.deletedAt(model.deletedAt);
        }

        public final String getVpcConnectorName() {
            return this.vpcConnectorName;
        }

        public final void setVpcConnectorName(String vpcConnectorName) {
            this.vpcConnectorName = vpcConnectorName;
        }

        @Override
        public final Builder vpcConnectorName(String vpcConnectorName) {
            this.vpcConnectorName = vpcConnectorName;
            return this;
        }

        public final String getVpcConnectorArn() {
            return this.vpcConnectorArn;
        }

        public final void setVpcConnectorArn(String vpcConnectorArn) {
            this.vpcConnectorArn = vpcConnectorArn;
        }

        @Override
        public final Builder vpcConnectorArn(String vpcConnectorArn) {
            this.vpcConnectorArn = vpcConnectorArn;
            return this;
        }

        public final Integer getVpcConnectorRevision() {
            return this.vpcConnectorRevision;
        }

        public final void setVpcConnectorRevision(Integer vpcConnectorRevision) {
            this.vpcConnectorRevision = vpcConnectorRevision;
        }

        @Override
        public final Builder vpcConnectorRevision(Integer vpcConnectorRevision) {
            this.vpcConnectorRevision = vpcConnectorRevision;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (this.subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VpcConnectorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getDeletedAt() {
            return this.deletedAt;
        }

        public final void setDeletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
        }

        @Override
        public final Builder deletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        public VpcConnector build() {
            return new VpcConnector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcConnector> {
        public Builder vpcConnectorName(String var1);

        public Builder vpcConnectorArn(String var1);

        public Builder vpcConnectorRevision(Integer var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder status(String var1);

        public Builder status(VpcConnectorStatus var1);

        public Builder createdAt(Instant var1);

        public Builder deletedAt(Instant var1);
    }
}

