/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apprunner.model.AuthenticationConfiguration;
import software.amazon.awssdk.services.apprunner.model.CodeRepository;
import software.amazon.awssdk.services.apprunner.model.ImageRepository;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceConfiguration> {
    private static final SdkField<CodeRepository> CODE_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodeRepository").getter(SourceConfiguration.getter(SourceConfiguration::codeRepository)).setter(SourceConfiguration.setter(Builder::codeRepository)).constructor(CodeRepository::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeRepository").build()}).build();
    private static final SdkField<ImageRepository> IMAGE_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageRepository").getter(SourceConfiguration.getter(SourceConfiguration::imageRepository)).setter(SourceConfiguration.setter(Builder::imageRepository)).constructor(ImageRepository::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageRepository").build()}).build();
    private static final SdkField<Boolean> AUTO_DEPLOYMENTS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoDeploymentsEnabled").getter(SourceConfiguration.getter(SourceConfiguration::autoDeploymentsEnabled)).setter(SourceConfiguration.setter(Builder::autoDeploymentsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoDeploymentsEnabled").build()}).build();
    private static final SdkField<AuthenticationConfiguration> AUTHENTICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthenticationConfiguration").getter(SourceConfiguration.getter(SourceConfiguration::authenticationConfiguration)).setter(SourceConfiguration.setter(Builder::authenticationConfiguration)).constructor(AuthenticationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_REPOSITORY_FIELD, IMAGE_REPOSITORY_FIELD, AUTO_DEPLOYMENTS_ENABLED_FIELD, AUTHENTICATION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SourceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CodeRepository codeRepository;
    private final ImageRepository imageRepository;
    private final Boolean autoDeploymentsEnabled;
    private final AuthenticationConfiguration authenticationConfiguration;

    private SourceConfiguration(BuilderImpl builder) {
        this.codeRepository = builder.codeRepository;
        this.imageRepository = builder.imageRepository;
        this.autoDeploymentsEnabled = builder.autoDeploymentsEnabled;
        this.authenticationConfiguration = builder.authenticationConfiguration;
    }

    public final CodeRepository codeRepository() {
        return this.codeRepository;
    }

    public final ImageRepository imageRepository() {
        return this.imageRepository;
    }

    public final Boolean autoDeploymentsEnabled() {
        return this.autoDeploymentsEnabled;
    }

    public final AuthenticationConfiguration authenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeRepository());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageRepository());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoDeploymentsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceConfiguration)) {
            return false;
        }
        SourceConfiguration other = (SourceConfiguration)obj;
        return Objects.equals(this.codeRepository(), other.codeRepository()) && Objects.equals(this.imageRepository(), other.imageRepository()) && Objects.equals(this.autoDeploymentsEnabled(), other.autoDeploymentsEnabled()) && Objects.equals(this.authenticationConfiguration(), other.authenticationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"SourceConfiguration").add("CodeRepository", (Object)this.codeRepository()).add("ImageRepository", (Object)this.imageRepository()).add("AutoDeploymentsEnabled", (Object)this.autoDeploymentsEnabled()).add("AuthenticationConfiguration", (Object)this.authenticationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CodeRepository": {
                return Optional.ofNullable(clazz.cast(this.codeRepository()));
            }
            case "ImageRepository": {
                return Optional.ofNullable(clazz.cast(this.imageRepository()));
            }
            case "AutoDeploymentsEnabled": {
                return Optional.ofNullable(clazz.cast(this.autoDeploymentsEnabled()));
            }
            case "AuthenticationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authenticationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CodeRepository", CODE_REPOSITORY_FIELD);
        map.put("ImageRepository", IMAGE_REPOSITORY_FIELD);
        map.put("AutoDeploymentsEnabled", AUTO_DEPLOYMENTS_ENABLED_FIELD);
        map.put("AuthenticationConfiguration", AUTHENTICATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceConfiguration, T> g) {
        return obj -> g.apply((SourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CodeRepository codeRepository;
        private ImageRepository imageRepository;
        private Boolean autoDeploymentsEnabled;
        private AuthenticationConfiguration authenticationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceConfiguration model) {
            this.codeRepository(model.codeRepository);
            this.imageRepository(model.imageRepository);
            this.autoDeploymentsEnabled(model.autoDeploymentsEnabled);
            this.authenticationConfiguration(model.authenticationConfiguration);
        }

        public final CodeRepository.Builder getCodeRepository() {
            return this.codeRepository != null ? this.codeRepository.toBuilder() : null;
        }

        public final void setCodeRepository(CodeRepository.BuilderImpl codeRepository) {
            this.codeRepository = codeRepository != null ? codeRepository.build() : null;
        }

        @Override
        public final Builder codeRepository(CodeRepository codeRepository) {
            this.codeRepository = codeRepository;
            return this;
        }

        public final ImageRepository.Builder getImageRepository() {
            return this.imageRepository != null ? this.imageRepository.toBuilder() : null;
        }

        public final void setImageRepository(ImageRepository.BuilderImpl imageRepository) {
            this.imageRepository = imageRepository != null ? imageRepository.build() : null;
        }

        @Override
        public final Builder imageRepository(ImageRepository imageRepository) {
            this.imageRepository = imageRepository;
            return this;
        }

        public final Boolean getAutoDeploymentsEnabled() {
            return this.autoDeploymentsEnabled;
        }

        public final void setAutoDeploymentsEnabled(Boolean autoDeploymentsEnabled) {
            this.autoDeploymentsEnabled = autoDeploymentsEnabled;
        }

        @Override
        public final Builder autoDeploymentsEnabled(Boolean autoDeploymentsEnabled) {
            this.autoDeploymentsEnabled = autoDeploymentsEnabled;
            return this;
        }

        public final AuthenticationConfiguration.Builder getAuthenticationConfiguration() {
            return this.authenticationConfiguration != null ? this.authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(AuthenticationConfiguration.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public SourceConfiguration build() {
            return new SourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceConfiguration> {
        public Builder codeRepository(CodeRepository var1);

        default public Builder codeRepository(Consumer<CodeRepository.Builder> codeRepository) {
            return this.codeRepository((CodeRepository)((CodeRepository.Builder)CodeRepository.builder().applyMutation(codeRepository)).build());
        }

        public Builder imageRepository(ImageRepository var1);

        default public Builder imageRepository(Consumer<ImageRepository.Builder> imageRepository) {
            return this.imageRepository((ImageRepository)((ImageRepository.Builder)ImageRepository.builder().applyMutation(imageRepository)).build());
        }

        public Builder autoDeploymentsEnabled(Boolean var1);

        public Builder authenticationConfiguration(AuthenticationConfiguration var1);

        default public Builder authenticationConfiguration(Consumer<AuthenticationConfiguration.Builder> authenticationConfiguration) {
            return this.authenticationConfiguration((AuthenticationConfiguration)((AuthenticationConfiguration.Builder)AuthenticationConfiguration.builder().applyMutation(authenticationConfiguration)).build());
        }
    }
}

