/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apprunner.model.AppRunnerResponse;
import software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary;
import software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAutoScalingConfigurationsResponse
extends AppRunnerResponse
implements ToCopyableBuilder<Builder, ListAutoScalingConfigurationsResponse> {
    private static final SdkField<List<AutoScalingConfigurationSummary>> AUTO_SCALING_CONFIGURATION_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutoScalingConfigurationSummaryList").getter(ListAutoScalingConfigurationsResponse.getter(ListAutoScalingConfigurationsResponse::autoScalingConfigurationSummaryList)).setter(ListAutoScalingConfigurationsResponse.setter(Builder::autoScalingConfigurationSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoScalingConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAutoScalingConfigurationsResponse.getter(ListAutoScalingConfigurationsResponse::nextToken)).setter(ListAutoScalingConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_CONFIGURATION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AutoScalingConfigurationSummaryList", AUTO_SCALING_CONFIGURATION_SUMMARY_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<AutoScalingConfigurationSummary> autoScalingConfigurationSummaryList;
    private final String nextToken;

    private ListAutoScalingConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.autoScalingConfigurationSummaryList = builder.autoScalingConfigurationSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAutoScalingConfigurationSummaryList() {
        return this.autoScalingConfigurationSummaryList != null && !(this.autoScalingConfigurationSummaryList instanceof SdkAutoConstructList);
    }

    public final List<AutoScalingConfigurationSummary> autoScalingConfigurationSummaryList() {
        return this.autoScalingConfigurationSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoScalingConfigurationSummaryList() ? this.autoScalingConfigurationSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutoScalingConfigurationsResponse)) {
            return false;
        }
        ListAutoScalingConfigurationsResponse other = (ListAutoScalingConfigurationsResponse)((Object)obj);
        return this.hasAutoScalingConfigurationSummaryList() == other.hasAutoScalingConfigurationSummaryList() && Objects.equals(this.autoScalingConfigurationSummaryList(), other.autoScalingConfigurationSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAutoScalingConfigurationsResponse").add("AutoScalingConfigurationSummaryList", this.hasAutoScalingConfigurationSummaryList() ? this.autoScalingConfigurationSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingConfigurationSummaryList": {
                return Optional.ofNullable(clazz.cast(this.autoScalingConfigurationSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAutoScalingConfigurationsResponse, T> g) {
        return obj -> g.apply((ListAutoScalingConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppRunnerResponse.BuilderImpl
    implements Builder {
        private List<AutoScalingConfigurationSummary> autoScalingConfigurationSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutoScalingConfigurationsResponse model) {
            super(model);
            this.autoScalingConfigurationSummaryList(model.autoScalingConfigurationSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<AutoScalingConfigurationSummary.Builder> getAutoScalingConfigurationSummaryList() {
            List<AutoScalingConfigurationSummary.Builder> result = AutoScalingConfigurationSummaryListCopier.copyToBuilder(this.autoScalingConfigurationSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoScalingConfigurationSummaryList(Collection<AutoScalingConfigurationSummary.BuilderImpl> autoScalingConfigurationSummaryList) {
            this.autoScalingConfigurationSummaryList = AutoScalingConfigurationSummaryListCopier.copyFromBuilder(autoScalingConfigurationSummaryList);
        }

        @Override
        public final Builder autoScalingConfigurationSummaryList(Collection<AutoScalingConfigurationSummary> autoScalingConfigurationSummaryList) {
            this.autoScalingConfigurationSummaryList = AutoScalingConfigurationSummaryListCopier.copy(autoScalingConfigurationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingConfigurationSummaryList(AutoScalingConfigurationSummary ... autoScalingConfigurationSummaryList) {
            this.autoScalingConfigurationSummaryList(Arrays.asList(autoScalingConfigurationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingConfigurationSummaryList(Consumer<AutoScalingConfigurationSummary.Builder> ... autoScalingConfigurationSummaryList) {
            this.autoScalingConfigurationSummaryList(Stream.of(autoScalingConfigurationSummaryList).map(c -> (AutoScalingConfigurationSummary)((AutoScalingConfigurationSummary.Builder)AutoScalingConfigurationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAutoScalingConfigurationsResponse build() {
            return new ListAutoScalingConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppRunnerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAutoScalingConfigurationsResponse> {
        public Builder autoScalingConfigurationSummaryList(Collection<AutoScalingConfigurationSummary> var1);

        public Builder autoScalingConfigurationSummaryList(AutoScalingConfigurationSummary ... var1);

        public Builder autoScalingConfigurationSummaryList(Consumer<AutoScalingConfigurationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

