/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apprunner.model.AppRunnerResponse;
import software.amazon.awssdk.services.apprunner.model.Service;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResumeServiceResponse
extends AppRunnerResponse
implements ToCopyableBuilder<Builder, ResumeServiceResponse> {
    private static final SdkField<Service> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Service").getter(ResumeServiceResponse.getter(ResumeServiceResponse::service)).setter(ResumeServiceResponse.setter(Builder::service)).constructor(Service::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()}).build();
    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationId").getter(ResumeServiceResponse.getter(ResumeServiceResponse::operationId)).setter(ResumeServiceResponse.setter(Builder::operationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD, OPERATION_ID_FIELD));
    private final Service service;
    private final String operationId;

    private ResumeServiceResponse(BuilderImpl builder) {
        super(builder);
        this.service = builder.service;
        this.operationId = builder.operationId;
    }

    public final Service service() {
        return this.service;
    }

    public final String operationId() {
        return this.operationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResumeServiceResponse)) {
            return false;
        }
        ResumeServiceResponse other = (ResumeServiceResponse)((Object)obj);
        return Objects.equals(this.service(), other.service()) && Objects.equals(this.operationId(), other.operationId());
    }

    public final String toString() {
        return ToString.builder((String)"ResumeServiceResponse").add("Service", (Object)this.service()).add("OperationId", (Object)this.operationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "OperationId": {
                return Optional.ofNullable(clazz.cast(this.operationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResumeServiceResponse, T> g) {
        return obj -> g.apply((ResumeServiceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppRunnerResponse.BuilderImpl
    implements Builder {
        private Service service;
        private String operationId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResumeServiceResponse model) {
            super(model);
            this.service(model.service);
            this.operationId(model.operationId);
        }

        public final Service.Builder getService() {
            return this.service != null ? this.service.toBuilder() : null;
        }

        public final void setService(Service.BuilderImpl service) {
            this.service = service != null ? service.build() : null;
        }

        @Override
        public final Builder service(Service service) {
            this.service = service;
            return this;
        }

        public final String getOperationId() {
            return this.operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        @Override
        public ResumeServiceResponse build() {
            return new ResumeServiceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppRunnerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResumeServiceResponse> {
        public Builder service(Service var1);

        default public Builder service(Consumer<Service.Builder> service) {
            return this.service((Service)((Service.Builder)Service.builder().applyMutation(service)).build());
        }

        public Builder operationId(String var1);
    }
}

