/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apprunner.AppRunnerClient;
import software.amazon.awssdk.services.apprunner.internal.UserAgentUtils;
import software.amazon.awssdk.services.apprunner.model.ListConnectionsRequest;
import software.amazon.awssdk.services.apprunner.model.ListConnectionsResponse;

public class ListConnectionsIterable
implements SdkIterable<ListConnectionsResponse> {
    private final AppRunnerClient client;
    private final ListConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConnectionsIterable(AppRunnerClient client, ListConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConnectionsResponseFetcher();
    }

    public Iterator<ListConnectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListConnectionsResponseFetcher
    implements SyncPageFetcher<ListConnectionsResponse> {
        private ListConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConnectionsResponse nextPage(ListConnectionsResponse previousPage) {
            if (previousPage == null) {
                return ListConnectionsIterable.this.client.listConnections(ListConnectionsIterable.this.firstRequest);
            }
            return ListConnectionsIterable.this.client.listConnections((ListConnectionsRequest)((Object)ListConnectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

