/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an App Runner connection resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Connection implements SdkPojo, Serializable, ToCopyableBuilder<Connection.Builder, Connection> {
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionName").getter(getter(Connection::connectionName)).setter(setter(Builder::connectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()).build();

    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionArn").getter(getter(Connection::connectionArn)).setter(setter(Builder::connectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()).build();

    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProviderType").getter(getter(Connection::providerTypeAsString)).setter(setter(Builder::providerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Connection::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(Connection::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_NAME_FIELD,
            CONNECTION_ARN_FIELD, PROVIDER_TYPE_FIELD, STATUS_FIELD, CREATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectionName;

    private final String connectionArn;

    private final String providerType;

    private final String status;

    private final Instant createdAt;

    private Connection(BuilderImpl builder) {
        this.connectionName = builder.connectionName;
        this.connectionArn = builder.connectionArn;
        this.providerType = builder.providerType;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The customer-provided connection name.
     * </p>
     * 
     * @return The customer-provided connection name.
     */
    public final String connectionName() {
        return connectionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of this connection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of this connection.
     */
    public final String connectionArn() {
        return connectionArn;
    }

    /**
     * <p>
     * The source repository provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The source repository provider.
     * @see ProviderType
     */
    public final ProviderType providerType() {
        return ProviderType.fromValue(providerType);
    }

    /**
     * <p>
     * The source repository provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link ProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The source repository provider.
     * @see ProviderType
     */
    public final String providerTypeAsString() {
        return providerType;
    }

    /**
     * <p>
     * The current state of the App Runner connection. When the state is <code>AVAILABLE</code>, you can use the
     * connection to create an App Runner service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the App Runner connection. When the state is <code>AVAILABLE</code>, you can use the
     *         connection to create an App Runner service.
     * @see ConnectionStatus
     */
    public final ConnectionStatus status() {
        return ConnectionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current state of the App Runner connection. When the state is <code>AVAILABLE</code>, you can use the
     * connection to create an App Runner service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the App Runner connection. When the state is <code>AVAILABLE</code>, you can use the
     *         connection to create an App Runner service.
     * @see ConnectionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The App Runner connection creation time, expressed as a Unix time stamp.
     * </p>
     * 
     * @return The App Runner connection creation time, expressed as a Unix time stamp.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Connection)) {
            return false;
        }
        Connection other = (Connection) obj;
        return Objects.equals(connectionName(), other.connectionName()) && Objects.equals(connectionArn(), other.connectionArn())
                && Objects.equals(providerTypeAsString(), other.providerTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Connection").add("ConnectionName", connectionName()).add("ConnectionArn", connectionArn())
                .add("ProviderType", providerTypeAsString()).add("Status", statusAsString()).add("CreatedAt", createdAt())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionName":
            return Optional.ofNullable(clazz.cast(connectionName()));
        case "ConnectionArn":
            return Optional.ofNullable(clazz.cast(connectionArn()));
        case "ProviderType":
            return Optional.ofNullable(clazz.cast(providerTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Connection, T> g) {
        return obj -> g.apply((Connection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Connection> {
        /**
         * <p>
         * The customer-provided connection name.
         * </p>
         * 
         * @param connectionName
         *        The customer-provided connection name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionName(String connectionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of this connection.
         * </p>
         * 
         * @param connectionArn
         *        The Amazon Resource Name (ARN) of this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionArn(String connectionArn);

        /**
         * <p>
         * The source repository provider.
         * </p>
         * 
         * @param providerType
         *        The source repository provider.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(String providerType);

        /**
         * <p>
         * The source repository provider.
         * </p>
         * 
         * @param providerType
         *        The source repository provider.
         * @see ProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProviderType
         */
        Builder providerType(ProviderType providerType);

        /**
         * <p>
         * The current state of the App Runner connection. When the state is <code>AVAILABLE</code>, you can use the
         * connection to create an App Runner service.
         * </p>
         * 
         * @param status
         *        The current state of the App Runner connection. When the state is <code>AVAILABLE</code>, you can use
         *        the connection to create an App Runner service.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of the App Runner connection. When the state is <code>AVAILABLE</code>, you can use the
         * connection to create an App Runner service.
         * </p>
         * 
         * @param status
         *        The current state of the App Runner connection. When the state is <code>AVAILABLE</code>, you can use
         *        the connection to create an App Runner service.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder status(ConnectionStatus status);

        /**
         * <p>
         * The App Runner connection creation time, expressed as a Unix time stamp.
         * </p>
         * 
         * @param createdAt
         *        The App Runner connection creation time, expressed as a Unix time stamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl implements Builder {
        private String connectionName;

        private String connectionArn;

        private String providerType;

        private String status;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Connection model) {
            connectionName(model.connectionName);
            connectionArn(model.connectionArn);
            providerType(model.providerType);
            status(model.status);
            createdAt(model.createdAt);
        }

        public final String getConnectionName() {
            return connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final String getConnectionArn() {
            return connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getProviderType() {
            return providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(ProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public Connection build() {
            return new Connection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
