/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apprunner.AppRunnerAsyncClient;
import software.amazon.awssdk.services.apprunner.model.ListObservabilityConfigurationsRequest;
import software.amazon.awssdk.services.apprunner.model.ListObservabilityConfigurationsResponse;

public class ListObservabilityConfigurationsPublisher
implements SdkPublisher<ListObservabilityConfigurationsResponse> {
    private final AppRunnerAsyncClient client;
    private final ListObservabilityConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListObservabilityConfigurationsPublisher(AppRunnerAsyncClient client, ListObservabilityConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListObservabilityConfigurationsPublisher(AppRunnerAsyncClient client, ListObservabilityConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListObservabilityConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListObservabilityConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListObservabilityConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListObservabilityConfigurationsResponse> {
        private ListObservabilityConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListObservabilityConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListObservabilityConfigurationsResponse> nextPage(ListObservabilityConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListObservabilityConfigurationsPublisher.this.client.listObservabilityConfigurations(ListObservabilityConfigurationsPublisher.this.firstRequest);
            }
            return ListObservabilityConfigurationsPublisher.this.client.listObservabilityConfigurations((ListObservabilityConfigurationsRequest)((Object)ListObservabilityConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

