/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConfigurationSource {
    REPOSITORY("REPOSITORY"),
    API("API"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConfigurationSource> VALUE_MAP;
    private final String value;

    private ConfigurationSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfigurationSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfigurationSource> knownValues() {
        EnumSet<ConfigurationSource> knownValues = EnumSet.allOf(ConfigurationSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConfigurationSource.class, ConfigurationSource::toString);
    }
}

