/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.AppMeshRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteVirtualServiceRequest
extends AppMeshRequest
implements ToCopyableBuilder<Builder, DeleteVirtualServiceRequest> {
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteVirtualServiceRequest.getter(DeleteVirtualServiceRequest::meshName)).setter(DeleteVirtualServiceRequest.setter(Builder::meshName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()}).build();
    private static final SdkField<String> VIRTUAL_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteVirtualServiceRequest.getter(DeleteVirtualServiceRequest::virtualServiceName)).setter(DeleteVirtualServiceRequest.setter(Builder::virtualServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualServiceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESH_NAME_FIELD, VIRTUAL_SERVICE_NAME_FIELD));
    private final String meshName;
    private final String virtualServiceName;

    private DeleteVirtualServiceRequest(BuilderImpl builder) {
        super(builder);
        this.meshName = builder.meshName;
        this.virtualServiceName = builder.virtualServiceName;
    }

    public String meshName() {
        return this.meshName;
    }

    public String virtualServiceName() {
        return this.virtualServiceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.meshName());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualServiceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVirtualServiceRequest)) {
            return false;
        }
        DeleteVirtualServiceRequest other = (DeleteVirtualServiceRequest)((Object)obj);
        return Objects.equals(this.meshName(), other.meshName()) && Objects.equals(this.virtualServiceName(), other.virtualServiceName());
    }

    public String toString() {
        return ToString.builder((String)"DeleteVirtualServiceRequest").add("MeshName", (Object)this.meshName()).add("VirtualServiceName", (Object)this.virtualServiceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "meshName": {
                return Optional.ofNullable(clazz.cast(this.meshName()));
            }
            case "virtualServiceName": {
                return Optional.ofNullable(clazz.cast(this.virtualServiceName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVirtualServiceRequest, T> g) {
        return obj -> g.apply((DeleteVirtualServiceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppMeshRequest.BuilderImpl
    implements Builder {
        private String meshName;
        private String virtualServiceName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVirtualServiceRequest model) {
            super(model);
            this.meshName(model.meshName);
            this.virtualServiceName(model.virtualServiceName);
        }

        public final String getMeshName() {
            return this.meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final String getVirtualServiceName() {
            return this.virtualServiceName;
        }

        @Override
        public final Builder virtualServiceName(String virtualServiceName) {
            this.virtualServiceName = virtualServiceName;
            return this;
        }

        public final void setVirtualServiceName(String virtualServiceName) {
            this.virtualServiceName = virtualServiceName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteVirtualServiceRequest build() {
            return new DeleteVirtualServiceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppMeshRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteVirtualServiceRequest> {
        public Builder meshName(String var1);

        public Builder virtualServiceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

