/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.AppMeshRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVirtualRouterRequest
extends AppMeshRequest
implements ToCopyableBuilder<Builder, DescribeVirtualRouterRequest> {
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeVirtualRouterRequest.getter(DescribeVirtualRouterRequest::meshName)).setter(DescribeVirtualRouterRequest.setter(Builder::meshName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()}).build();
    private static final SdkField<String> VIRTUAL_ROUTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeVirtualRouterRequest.getter(DescribeVirtualRouterRequest::virtualRouterName)).setter(DescribeVirtualRouterRequest.setter(Builder::virtualRouterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualRouterName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESH_NAME_FIELD, VIRTUAL_ROUTER_NAME_FIELD));
    private final String meshName;
    private final String virtualRouterName;

    private DescribeVirtualRouterRequest(BuilderImpl builder) {
        super(builder);
        this.meshName = builder.meshName;
        this.virtualRouterName = builder.virtualRouterName;
    }

    public String meshName() {
        return this.meshName;
    }

    public String virtualRouterName() {
        return this.virtualRouterName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.meshName());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualRouterName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVirtualRouterRequest)) {
            return false;
        }
        DescribeVirtualRouterRequest other = (DescribeVirtualRouterRequest)((Object)obj);
        return Objects.equals(this.meshName(), other.meshName()) && Objects.equals(this.virtualRouterName(), other.virtualRouterName());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVirtualRouterRequest").add("MeshName", (Object)this.meshName()).add("VirtualRouterName", (Object)this.virtualRouterName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "meshName": {
                return Optional.ofNullable(clazz.cast(this.meshName()));
            }
            case "virtualRouterName": {
                return Optional.ofNullable(clazz.cast(this.virtualRouterName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVirtualRouterRequest, T> g) {
        return obj -> g.apply((DescribeVirtualRouterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppMeshRequest.BuilderImpl
    implements Builder {
        private String meshName;
        private String virtualRouterName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVirtualRouterRequest model) {
            super(model);
            this.meshName(model.meshName);
            this.virtualRouterName(model.virtualRouterName);
        }

        public final String getMeshName() {
            return this.meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final String getVirtualRouterName() {
            return this.virtualRouterName;
        }

        @Override
        public final Builder virtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
            return this;
        }

        public final void setVirtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeVirtualRouterRequest build() {
            return new DescribeVirtualRouterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppMeshRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVirtualRouterRequest> {
        public Builder meshName(String var1);

        public Builder virtualRouterName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

