/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.AppMeshRequest;
import software.amazon.awssdk.services.appmesh.model.VirtualServiceSpec;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVirtualServiceRequest
extends AppMeshRequest
implements ToCopyableBuilder<Builder, UpdateVirtualServiceRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateVirtualServiceRequest.getter(UpdateVirtualServiceRequest::clientToken)).setter(UpdateVirtualServiceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateVirtualServiceRequest.getter(UpdateVirtualServiceRequest::meshName)).setter(UpdateVirtualServiceRequest.setter(Builder::meshName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()}).build();
    private static final SdkField<VirtualServiceSpec> SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateVirtualServiceRequest.getter(UpdateVirtualServiceRequest::spec)).setter(UpdateVirtualServiceRequest.setter(Builder::spec)).constructor(VirtualServiceSpec::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()}).build();
    private static final SdkField<String> VIRTUAL_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateVirtualServiceRequest.getter(UpdateVirtualServiceRequest::virtualServiceName)).setter(UpdateVirtualServiceRequest.setter(Builder::virtualServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualServiceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, MESH_NAME_FIELD, SPEC_FIELD, VIRTUAL_SERVICE_NAME_FIELD));
    private final String clientToken;
    private final String meshName;
    private final VirtualServiceSpec spec;
    private final String virtualServiceName;

    private UpdateVirtualServiceRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.meshName = builder.meshName;
        this.spec = builder.spec;
        this.virtualServiceName = builder.virtualServiceName;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String meshName() {
        return this.meshName;
    }

    public VirtualServiceSpec spec() {
        return this.spec;
    }

    public String virtualServiceName() {
        return this.virtualServiceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.meshName());
        hashCode = 31 * hashCode + Objects.hashCode(this.spec());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualServiceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVirtualServiceRequest)) {
            return false;
        }
        UpdateVirtualServiceRequest other = (UpdateVirtualServiceRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.meshName(), other.meshName()) && Objects.equals(this.spec(), other.spec()) && Objects.equals(this.virtualServiceName(), other.virtualServiceName());
    }

    public String toString() {
        return ToString.builder((String)"UpdateVirtualServiceRequest").add("ClientToken", (Object)this.clientToken()).add("MeshName", (Object)this.meshName()).add("Spec", (Object)this.spec()).add("VirtualServiceName", (Object)this.virtualServiceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "meshName": {
                return Optional.ofNullable(clazz.cast(this.meshName()));
            }
            case "spec": {
                return Optional.ofNullable(clazz.cast(this.spec()));
            }
            case "virtualServiceName": {
                return Optional.ofNullable(clazz.cast(this.virtualServiceName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVirtualServiceRequest, T> g) {
        return obj -> g.apply((UpdateVirtualServiceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppMeshRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String meshName;
        private VirtualServiceSpec spec;
        private String virtualServiceName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVirtualServiceRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.meshName(model.meshName);
            this.spec(model.spec);
            this.virtualServiceName(model.virtualServiceName);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getMeshName() {
            return this.meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final VirtualServiceSpec.Builder getSpec() {
            return this.spec != null ? this.spec.toBuilder() : null;
        }

        @Override
        public final Builder spec(VirtualServiceSpec spec) {
            this.spec = spec;
            return this;
        }

        public final void setSpec(VirtualServiceSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        public final String getVirtualServiceName() {
            return this.virtualServiceName;
        }

        @Override
        public final Builder virtualServiceName(String virtualServiceName) {
            this.virtualServiceName = virtualServiceName;
            return this;
        }

        public final void setVirtualServiceName(String virtualServiceName) {
            this.virtualServiceName = virtualServiceName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVirtualServiceRequest build() {
            return new UpdateVirtualServiceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppMeshRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVirtualServiceRequest> {
        public Builder clientToken(String var1);

        public Builder meshName(String var1);

        public Builder spec(VirtualServiceSpec var1);

        default public Builder spec(Consumer<VirtualServiceSpec.Builder> spec) {
            return this.spec((VirtualServiceSpec)((VirtualServiceSpec.Builder)VirtualServiceSpec.builder().applyMutation(spec)).build());
        }

        public Builder virtualServiceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

